/*
     Copyright (c) 1999,2010 Michael Dillon

     Permission is hereby granted, free of charge, to any person obtaining a copy
     of this software and associated documentation files (the "Software"), to deal
     in the Software without restriction, including without limitation the rights
     to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
     copies of the Software, and to permit persons to whom the Software is
     furnished to do so, subject to the following conditions:
     
     The above copyright notice and this permission notice shall be included in
     all copies or substantial portions of the Software.
     
     THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
     IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
     FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
     AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
     LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
     OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
     THE SOFTWARE.
*/
//#include <stdio.h>
//#include <stdlib.h>
#include "lordstrc.h"

struct _setup {
	unsigned char lordloc[80];
} setup = { "\x0" };

template <class BinFile> signed short int LoadBinaryFile(unsigned char *File_Name, BinFile *struc, unsigned short int s_size);
template <class BinFile> signed short int SaveBinaryFile(unsigned char *File_Name, BinFile *struc, unsigned short int s_size, signed short int s_records);

signed short int LoadBinaryFile(unsigned char *File_Name, player_info *struc, unsigned short int s_size);
signed short int LoadBinaryFile(unsigned char *File_Name, monst *struc, unsigned short int s_size);
signed short int LoadBinaryFile(unsigned char *File_Name, _setup *struc, unsigned short int s_size);
signed short int SaveBinaryFile(unsigned char *File_Name, player_info *struc, unsigned short int s_size, signed short int s_records);
signed short int SaveBinaryFile(unsigned char *File_Name, monst *struc, unsigned short int s_size, signed short int s_records);
signed short int SaveBinaryFile(unsigned char *File_Name, _setup *struc, unsigned short int s_size, signed short int s_records);

// Start of template
template <class BinFile> signed short int LoadBinaryFile(unsigned char *File_Name, BinFile *struc, unsigned short int s_size)
{
	FILE *LFile;
	signed short int r_status = 0, s_idx = 0;
	if ((LFile = fopen(File_Name, "rb")) == NULL)
	{
		fprintf(stderr, "Unable to open %s for input!", File_Name);
		fflush(stderr);
		return (-1); // Failed open
	}
	do {
		r_status = fread(&struc[s_idx], s_size, 1, LFile);
		if (r_status != 0)
		{
			s_idx++;
		}
		if (s_idx > 255)
		{
			break; // Break before data overflow
		}
	} while (!feof(LFile) && r_status != 0);
	fclose(LFile);
	return (s_idx);
}

template <class BinFile> signed short int SaveBinaryFile(unsigned char *File_Name, BinFile *struc, unsigned short int s_size, signed short int s_records)
{
	FILE *SFile;
	signed short int idx = 0, w_status = 0;
	signed short int w_times = 1;
	if ((SFile = fopen(File_Name, "wb")) == NULL)
	{
		fprintf(stderr, "Unable to open %s for output!", File_Name);
		fflush(stderr);
		return (-1);
	}
	do {
		w_status = fwrite(&struc[idx], s_size, w_times, SFile);
		if (w_status != w_times)
		{
			fclose(SFile);
			fprintf(stderr, "Error occurred while attempting to write to %s.", File_Name);
			fflush(stderr);
			return (-1);
		}
		else
		{
			idx++;
		}
	} while (idx < s_records);
	fclose(SFile);
	return (0);
}
