/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.collection;

import org.ckkloverdos.log.StdLog;
import org.ckkloverdos.string.IToStringAware;
import org.ckkloverdos.string.ToString;

public final class IntArray
implements IToStringAware {
    private int[] array;
    private int nextPosition;

    public IntArray() {
        this.array = new int[10];
        this.nextPosition = 0;
    }

    public IntArray(int initialCapacity) {
        initialCapacity = initialCapacity <= 0 ? 10 : initialCapacity;
        this.array = new int[initialCapacity];
        this.nextPosition = 0;
    }

    public IntArray(int[] array) {
        this.array = array;
        this.nextPosition = this.array.length;
    }

    public void add(int i) {
        if (this.nextPosition == this.array.length) {
            int[] newArray = new int[(this.nextPosition << 1) + this.nextPosition >>> 1];
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            this.array = newArray;
        }
        this.array[this.nextPosition++] = i;
    }

    public int length() {
        return this.nextPosition;
    }

    public void removeByIndex(int index) {
        if (index < 0 || index >= this.nextPosition) {
            throw new ArrayIndexOutOfBoundsException("Bad index " + index);
        }
        System.arraycopy(this.array, index + 1, this.array, index, this.nextPosition - index - 1);
        --this.nextPosition;
    }

    public int[] array() {
        return this.array;
    }

    public void ensureCapacity(int length) {
        if (length > this.array.length) {
            int[] newArray = new int[length];
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            this.array = newArray;
        }
    }

    public void set(int index, int value) {
        if (index < 0 || index >= this.nextPosition) {
            throw new ArrayIndexOutOfBoundsException("Bad index " + index);
        }
        this.array[index] = value;
    }

    public void increase(int index) {
        if (index < 0 || index >= this.nextPosition) {
            throw new ArrayIndexOutOfBoundsException("Bad index " + index);
        }
        int n = index;
        this.array[n] = this.array[n] + 1;
    }

    public void decrease(int index) {
        if (index < 0 || index >= this.nextPosition) {
            throw new ArrayIndexOutOfBoundsException("Bad index " + index);
        }
        int n = index;
        this.array[n] = this.array[n] - 1;
    }

    public void increaseBy(int index, int value) {
        if (index < 0 || index >= this.nextPosition) {
            throw new ArrayIndexOutOfBoundsException("Bad index " + index);
        }
        int n = index;
        this.array[n] = this.array[n] + value;
    }

    public void decreaseBy(int index, int value) {
        if (index < 0 || index >= this.nextPosition) {
            throw new ArrayIndexOutOfBoundsException("Bad index " + index);
        }
        int n = index;
        this.array[n] = this.array[n] - value;
    }

    public int get(int index) {
        if (index < 0 || index >= this.nextPosition) {
            throw new ArrayIndexOutOfBoundsException("Bad index " + index);
        }
        return this.array[index];
    }

    public int first() {
        return this.array[0];
    }

    public int last() {
        return this.array[this.nextPosition - 1];
    }

    public void push(int i) {
        if (this.nextPosition == this.array.length) {
            int[] newArray = new int[(this.nextPosition << 1) + this.nextPosition >>> 1];
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            this.array = newArray;
        }
        this.array[this.nextPosition++] = i;
    }

    public int peek() {
        return this.array[this.nextPosition - 1];
    }

    public int pop() {
        int i = this.array[this.nextPosition - 1];
        --this.nextPosition;
        return i;
    }

    public void compact() {
        if (this.nextPosition < this.array.length) {
            int[] newArray = new int[this.nextPosition];
            System.arraycopy(this.array, 0, newArray, 0, this.nextPosition);
            this.array = newArray;
        }
    }

    public String toString() {
        ToString ts = new ToString(this);
        this.toStringAware(ts);
        return ts.toString();
    }

    public void toStringAware(ToString ts) {
        for (int i = 0; i < this.nextPosition; ++i) {
            ts.add("" + i, this.array[i]);
        }
    }

    public static void main(String[] args) {
        IntArray a = new IntArray(0);
        a.add(0);
        a.add(1);
        a.add(2);
        StdLog.log("length = " + a.length() + ", a = " + a);
        a.removeByIndex(2);
        StdLog.log("length = " + a.length() + ", a = " + a);
        a.push(3);
        StdLog.log("length = " + a.length() + ", a = " + a);
        StdLog.log("a.first() = " + a.first());
        StdLog.log("a.last() = " + a.last());
    }
}

