/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import org.ckkloverdos.io.IReadLine;
import org.ckkloverdos.io.ReadLineFromReader;
import org.ckkloverdos.log.StdLog;

public class IOUtil {
    public static byte[] readBytes(InputStream is, boolean close) throws IOException {
        int count;
        byte[] result = new byte[]{};
        byte[] buffer = new byte[8192];
        while ((count = is.read(buffer)) > -1) {
            byte[] newresult = new byte[result.length + count];
            System.arraycopy(result, 0, newresult, 0, result.length);
            System.arraycopy(buffer, 0, newresult, result.length, count);
            result = newresult;
        }
        if (close) {
            is.close();
        }
        return result;
    }

    public static byte[] readBytes(InputStream is) throws IOException {
        return IOUtil.readBytes(is, false);
    }

    public static String readString(InputStream is, boolean close) throws IOException {
        return new String(IOUtil.readBytes(is, close), "UTF-8");
    }

    public static String readString(InputStream is) throws IOException {
        return new String(IOUtil.readBytes(is, false), "UTF-8");
    }

    public static String readString(InputStream is, String encoding, boolean close) throws IOException {
        return new String(IOUtil.readBytes(is, close), encoding);
    }

    public static String readString(InputStream is, String encoding) throws IOException {
        return new String(IOUtil.readBytes(is, false), encoding);
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        int count;
        byte[] buffer = new byte[1024];
        while ((count = is.read(buffer)) > -1) {
            os.write(buffer, 0, count);
        }
    }

    public static String readString(File file) throws IOException {
        return IOUtil.readString(file, "UTF-8");
    }

    public static String readString(File file, String encoding) throws IOException {
        return IOUtil.readString(new FileInputStream(file), encoding, true);
    }

    public static InputStream safeOpenStream(URL url) {
        try {
            return url.openStream();
        }
        catch (NullPointerException e) {
            StdLog.error(e);
        }
        catch (IOException e) {
            StdLog.error(e);
        }
        return null;
    }

    public static void safeClose(InputStream is) {
        try {
            is.close();
        }
        catch (Exception e) {
            StdLog.error(e);
        }
    }

    public static String getFileLine(File f, int line) {
        return IOUtil.getFileLine(f, line, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileLine(File f, int line, String encoding) {
        BufferedReader br;
        InputStreamReader r;
        FileInputStream fis;
        block11: {
            String string;
            block10: {
                if (line <= 0) {
                    return null;
                }
                if (null == encoding) {
                    encoding = "UTF-8";
                }
                fis = null;
                r = null;
                br = null;
                try {
                    fis = new FileInputStream(f);
                    r = new InputStreamReader((InputStream)fis, encoding);
                    br = new BufferedReader(r);
                    int n = 1;
                    String s = br.readLine();
                    while (null != s) {
                        if (n == line) {
                            string = s;
                            IOUtil.safeClose(br);
                            break block10;
                        }
                        s = br.readLine();
                        ++n;
                    }
                    IOUtil.safeClose(br);
                    break block11;
                }
                catch (Exception e) {
                    StdLog.error(e);
                    return null;
                }
            }
            IOUtil.safeClose(r);
            IOUtil.safeClose(fis);
            return string;
        }
        IOUtil.safeClose(r);
        IOUtil.safeClose(fis);
        return null;
        finally {
            IOUtil.safeClose(br);
            IOUtil.safeClose(r);
            IOUtil.safeClose(fis);
        }
    }

    public static void safeClose(Reader r) {
        try {
            r.close();
        }
        catch (Exception e) {
            StdLog.error(e);
        }
    }

    public static IReadLine readLineFromReader(BufferedReader br) {
        return new ReadLineFromReader(br);
    }

    public static IReadLine readLineFromReader(Reader r) {
        return new ReadLineFromReader(r);
    }

    public static String getFileExtension(File file) throws IOException {
        String fileName;
        int dotPos;
        String pname;
        String ext = "";
        String name = file.getAbsolutePath();
        if (!name.equals(pname = new File(name).getParentFile().getAbsolutePath()) && -1 != (dotPos = (fileName = name.substring(name.indexOf(pname) + pname.length())).lastIndexOf(46))) {
            ext = fileName.substring(dotPos + 1);
        }
        return ext;
    }

    public static String getFileExtension(String name) throws IOException {
        return IOUtil.getFileExtension(new File(name));
    }
}

