/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.java;

import org.ckkloverdos.util.Util;

public final class JavaVersion {
    private int major;
    private int minor;
    private String patch = "";
    private double patchNumber;
    public static final JavaVersion JAVA_VERSION = new JavaVersion();

    public JavaVersion() {
        String version = System.getProperty("java.version");
        String[] parts = version.split("\\.");
        this.major = Util.safe(parts[0], 0);
        if (parts.length > 1) {
            this.minor = Util.safe(parts[1], 0);
            if (parts.length > 2) {
                this.patch = parts[2];
                this.patchNumber = this.getPatch(this.patch);
            }
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    private double getPatch(String patch) {
        return Double.parseDouble(patch.replace('_', '.'));
    }

    public int compare(int major, int minor, String patch) {
        int dmajor = JavaVersion.JAVA_VERSION.major - major;
        if (0 != dmajor) {
            return dmajor;
        }
        int dminor = JavaVersion.JAVA_VERSION.minor - minor;
        if (0 != dminor) {
            return dminor;
        }
        double dpatchN = JavaVersion.JAVA_VERSION.patchNumber - this.getPatch(patch);
        return dpatchN < 0.0 ? -1 : (dpatchN > 0.0 ? 1 : 0);
    }

    public int compare(int major, int minor) {
        int dmajor = JavaVersion.JAVA_VERSION.major - major;
        if (0 != dmajor) {
            return dmajor;
        }
        return JavaVersion.JAVA_VERSION.minor - minor;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patchNumber;
    }
}

