/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.string;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.regex.Pattern;
import org.ckkloverdos.log.StdLog;
import org.ckkloverdos.util.Util;

public final class StringUtil {
    public static Pattern DOT_PATTERN = Pattern.compile("\\.");
    public static final String UTF8 = "UTF-8";
    public static final String EMPTY_STRING = "";
    public static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private StringUtil() {
    }

    public static String toHex(byte[] b) {
        StringBuffer sb = new StringBuffer(2 * b.length);
        for (int i = 0; i < b.length; ++i) {
            int high = b[i] >>> 4 & 0xF;
            int low = b[i] & 0xF;
            sb.append(StringUtil.hexToAscii(high));
            sb.append(StringUtil.hexToAscii(low));
        }
        return sb.toString();
    }

    public static String toHex(byte b) {
        int high = b >>> 4 & 0xF;
        int low = b & 0xF;
        StringBuffer sb = new StringBuffer(2);
        sb.append(StringUtil.hexToAscii(high));
        sb.append(StringUtil.hexToAscii(low));
        return sb.toString();
    }

    public static char hexToAscii(int h) {
        if (h >= 10 && h <= 15) {
            return (char)(65 + (h - 10));
        }
        if (h >= 0 && h <= 9) {
            return (char)(48 + h);
        }
        return '0';
    }

    public static String messageDigest(String input) {
        return StringUtil.messageDigest(input, null, null);
    }

    public static String messageDigest(String input, String algorithm) {
        return StringUtil.messageDigest(input, algorithm, null);
    }

    public static String messageDigest(String msg, String algorithm, String encoding) {
        if (null == algorithm) {
            algorithm = "SHA1";
        }
        if (null == encoding) {
            encoding = UTF8;
        }
        try {
            MessageDigest sha1 = MessageDigest.getInstance(algorithm);
            sha1.reset();
            sha1.update(msg.getBytes(encoding));
            return StringUtil.toHex(sha1.digest());
        }
        catch (NoSuchAlgorithmException e) {
            StdLog.warn("SHA1 is not implemented! Going to use cleartext password...");
            return msg;
        }
        catch (UnsupportedEncodingException e) {
            StdLog.warn("Encoding " + encoding + " is not supported???");
            StdLog.warn("Going to use cleartext password...");
            return msg;
        }
    }

    public static String safeRemoveSuffixRepeat(String str, String suffix) {
        if (null != suffix && null != str) {
            while (str.endsWith(suffix)) {
                str = str.substring(0, str.length() - suffix.length());
            }
            str = new String(str);
        }
        return Util.safe(str);
    }

    public static String getStringPart(String str, String regularExpression, int index) {
        try {
            return str.split(regularExpression)[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            StdLog.error(e);
            return null;
        }
    }

    public static String safeRemoveSuffix(String str, String suffix) {
        if (null != suffix && null != str && str.endsWith(suffix)) {
            str = new String(str.substring(0, str.length() - suffix.length()));
        }
        return Util.safe(str);
    }

    public static String substring(String s, int beginIndex) {
        return new String(s.substring(beginIndex));
    }

    public static String substring(String s, int beginIndex, int endIndex) {
        return new String(s.substring(beginIndex, endIndex));
    }

    public static String[] splitDots(String s) {
        return DOT_PATTERN.split(s);
    }

    public static String getStringUID() {
        return StringUtil.getStringUID(Util.RANDOM);
    }

    public static String getStringUID(Random random) {
        StringBuffer sb = new StringBuffer();
        sb.append(Util.getLocalHost());
        sb.append("-");
        sb.append(random.nextLong());
        sb.append("-");
        double d1 = random.nextDouble();
        double d2 = random.nextDouble();
        sb.append((d1 - d2) * (d1 - d2) + d1 * d2);
        String md = StringUtil.messageDigest(sb.toString());
        return md;
    }

    public static String getTextLine(String text, int n) {
        if (n <= 0) {
            return null;
        }
        StringReader sr = new StringReader(text);
        BufferedReader br = new BufferedReader(sr);
        try {
            int _n = 1;
            String s = br.readLine();
            while (null != s) {
                if (_n == n) {
                    return s;
                }
                s = br.readLine();
                ++_n;
            }
        }
        catch (IOException e) {
            StdLog.error(e);
        }
        return null;
    }
}

