/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.util;

import java.util.Collection;
import org.ckkloverdos.collection.IL;
import org.ckkloverdos.util.CallUtil;
import org.ckkloverdos.util.UnsatisfiedConditionException;
import org.ckkloverdos.util.Util;

public final class Assert {
    private Assert() {
    }

    private static String getMsg(String msg) {
        StackTraceElement[] st = CallUtil.getStackTrace();
        if (null == msg) {
            return "Failed " + st[1].getMethodName() + "() assertion at " + st[2].getClassName() + "::" + st[2].getMethodName();
        }
        return "Failed " + st[1].getMethodName() + "() assertion at " + st[2].getClassName() + "::" + st[2].getMethodName() + ": " + msg;
    }

    public static void notNull(Object o) {
        if (null == o) {
            throw new NullPointerException(Assert.getMsg(null));
        }
    }

    public static void notNull(Object o, String msg) {
        if (null == o) {
            throw new NullPointerException(Assert.getMsg(msg));
        }
    }

    public static void notNullObject(Object o, String objectName) {
        if (null == o) {
            throw new NullPointerException(Assert.getMsg(objectName + " must not be null"));
        }
    }

    public static void holds(boolean condition) {
        if (!condition) {
            throw new UnsatisfiedConditionException(Assert.getMsg(null));
        }
    }

    public static void holds(boolean condition, String msg) {
        if (!condition) {
            throw new UnsatisfiedConditionException(Assert.getMsg(msg));
        }
    }

    public static void notEmpty(String s) {
        if (Util.emptySafe(s)) {
            throw new UnsatisfiedConditionException(Assert.getMsg(null));
        }
    }

    public static void notEmpty(String s, String msg) {
        if (Util.emptySafe(s)) {
            throw new UnsatisfiedConditionException(Assert.getMsg(msg));
        }
    }

    public static void notEmpty(Object[] array) {
        if (Util.emptySafe(array)) {
            throw new UnsatisfiedConditionException(Assert.getMsg(null));
        }
    }

    public static void notEmpty(Object[] array, String msg) {
        if (Util.emptySafe(array)) {
            throw new UnsatisfiedConditionException(Assert.getMsg(msg));
        }
    }

    public static void notEmpty(Collection collection) {
        if (Util.emptySafe(collection)) {
            throw new UnsatisfiedConditionException(Assert.getMsg(null));
        }
    }

    public static void notEmpty(Collection collection, String msg) {
        if (Util.emptySafe(collection)) {
            throw new UnsatisfiedConditionException(Assert.getMsg(msg));
        }
    }

    public static void notEmpty(IL list) {
        if (Util.emptySafe(list)) {
            throw new UnsatisfiedConditionException(Assert.getMsg(null));
        }
    }

    public static void notEmpty(IL list, String msg) {
        if (Util.emptySafe(list)) {
            throw new UnsatisfiedConditionException(Assert.getMsg(msg));
        }
    }

    public static void isSublass(Class subClass, Class ofClass) {
        if (!ofClass.isAssignableFrom(subClass)) {
            throw new UnsatisfiedConditionException(Assert.getMsg(null));
        }
    }

    public static void isSublass(Class subClass, Class ofClass, String msg) {
        if (!ofClass.isAssignableFrom(subClass)) {
            throw new UnsatisfiedConditionException(Assert.getMsg(msg));
        }
    }

    public static void isSublassSafe(Object o, Class ofClass) {
        if (null != o && !ofClass.isAssignableFrom(o.getClass())) {
            throw new UnsatisfiedConditionException(Assert.getMsg(null));
        }
    }

    public static void isSublassSafe(Object o, Class ofClass, String msg) {
        if (null != o && !ofClass.isAssignableFrom(o.getClass())) {
            throw new UnsatisfiedConditionException(Assert.getMsg(msg));
        }
    }

    public static void main(String[] args) {
        Assert.holds(false);
    }
}

