/*
 * Decompiled with CFR 0.152.
 */
package org.ckkloverdos.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.ckkloverdos.util.Util;

public final class ClassUtil {
    private ClassUtil() {
    }

    public static String identity(Class c) {
        return System.identityHashCode(c.getClassLoader()) + "/" + c.getName();
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static URL getContextResource(String name) {
        return ClassUtil.getContextClassLoader().getResource(name);
    }

    public static URL getFileOrResource(String name) {
        File f = new File(name);
        if (f.isFile()) {
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return ClassUtil.getContextResource(name);
    }

    public static InputStream getFileOrResourceAsStream(String name) throws IOException {
        URL url = ClassUtil.getFileOrResource(name);
        if (null == url) {
            return null;
        }
        return url.openStream();
    }

    public static Class loadClass(String name) {
        try {
            return ClassUtil.getContextClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }

    public static Object newInstance(Class c) {
        if (null == c) {
            return null;
        }
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static Object newInstance(String className) {
        return ClassUtil.newInstance(ClassUtil.loadClass(className));
    }

    public static Object newInstance(String className, ClassLoader cl) {
        return ClassUtil.newInstance(ClassUtil.loadClass(className, cl));
    }

    public static Class loadClass(String name, ClassLoader loader) {
        if (null == loader) {
            return ClassUtil.loadClass(name);
        }
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class forName(String name, URL[] urls) {
        try {
            if (Util.emptySafe(urls)) {
                return ClassUtil.loadClass(name);
            }
            return Class.forName(name, false, URLClassLoader.newInstance(urls, ClassLoader.getSystemClassLoader()));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static String getShortClassName(Class c) {
        return ClassUtil.getShortClassName(c.getName());
    }

    public static String getShortClassName(String name) {
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public static String getShortClassName(Object o) {
        return ClassUtil.getShortClassName(o.getClass());
    }

    public static String normalizeClassName(Class c) {
        StringBuffer sb = new StringBuffer();
        while (c.isArray()) {
            sb.append("[]");
            c = c.getComponentType();
        }
        sb.insert(0, c.getName());
        return sb.toString();
    }

    public static String normalizeClassName(String name) {
        int dim = 0;
        while (name.charAt(dim) == '[') {
            ++dim;
        }
        name = name.substring(dim);
        if (dim > 0) {
            switch (name.charAt(0)) {
                case 'B': {
                    name = "byte";
                    break;
                }
                case 'C': {
                    name = "char";
                    break;
                }
                case 'D': {
                    name = "double";
                    break;
                }
                case 'F': {
                    name = "float";
                    break;
                }
                case 'I': {
                    name = "int";
                    break;
                }
                case 'J': {
                    name = "long";
                    break;
                }
                case 'S': {
                    name = "short";
                    break;
                }
                case 'V': {
                    name = "void";
                    break;
                }
                case 'Z': {
                    name = "bool";
                    break;
                }
                case 'L': {
                    name = name.substring(1, name.length() - 1);
                }
            }
        }
        for (int i = 0; i < dim; ++i) {
            name = name + "[]";
        }
        return name;
    }
}

