/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.db.proxy;

import java.sql.Driver;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

/**
 * An {@link java.lang.reflect.InvocationHandler} wrapping a JDBC driver
 * instance. We use this when {@link org.ckkloverdos.db.DbUtil#registerDriver(String, ClassLoader) registering}
 * a driver that has been dynamically loaded into the VM, i.e. that is was not
 * defined in the <code>CLASSPATH</code>, in order to make sure that the wrapping instance
 * is created from the application's class loader. This constraint is imposed by the
 * {@link java.sql.DriverManager} in order for the driver to be usable.
 * 
 * @author Christos KK Loverdos
 * @see java.sql.DriverManager
 */

public final class DriverInvocationHandler implements InvocationHandler
{
    private Driver driver;

    public DriverInvocationHandler(Driver driver)
    {
        this.driver = driver;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable
    {
        return method.invoke(driver, args);
    }
}
