/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.hint;

/**
 * Default implementation for a {@link org.ckkloverdos.hint.IHint} represented
 * by some object.
 *
 * @author Christos KK Loverdos
 */
public class UnaryHint implements IHint
{
    private Object hint;

    public UnaryHint(Object hint)
    {
        this.hint = hint;
    }

    public Object getHint()
    {
        return hint;
    }

    public void setHint(Object hint)
    {
        this.hint = hint;
    }

    public boolean isNull()
    {
        return null == hint;
    }

    public boolean equals(Object o)
    {
        if(this == o)
        {
            return true;
        }
        if(o == null || getClass() != o.getClass())
        {
            return false;
        }

        UnaryHint unaryHint = (UnaryHint) o;

        if(hint != null ? !hint.equals(unaryHint.hint) : unaryHint.hint != null)
        {
            return false;
        }

        return true;
    }

    public int hashCode()
    {
        return (hint != null ? hint.hashCode() : 0);
    }
}
