package org.ckkloverdos.type.java;

import org.ckkloverdos.util.ClassUtil;

/**
 * A generic {@link String name} and {@link org.ckkloverdos.type.java.JavaType type} placeholder.
 * 
 * @author Christos KK Loverdos
 */
public class NameAndType
{
    private String name;
    private JavaType type;

    public NameAndType(NameAndType nt)
    {
        this.name = nt.name;
        this.type = nt.type;
    }
    
    public NameAndType(String name, JavaType type)
    {
        this.name = name;
        this.type = type;
    }

    /**
     * Returns the name of this instance.
     */
    public String getName()
    {
        return name;
    }

    /**
     * Returns the <code>JavaType</code> of this instance.
     */
    public JavaType getType()
    {
        return type;
    }

    public boolean equals(Object o)
    {
        if(this == o)
        {
            return true;
        }
        if(o == null || getClass() != o.getClass())
        {
            return false;
        }

        NameAndType nameAndType = (NameAndType) o;

        if(name != null ? !name.equals(nameAndType.name) : nameAndType.name != null)
        {
            return false;
        }
        if(type != null ? !type.equals(nameAndType.type) : nameAndType.type != null)
        {
            return false;
        }

        return true;
    }

    public int hashCode()
    {
        int result;
        result = (name != null ? name.hashCode() : 0);
        result = 31 * result + (type != null ? type.hashCode() : 0);
        return result;
    }

    public String getDescription()
    {
        return "(" + name + ", " + type.getDescription() + ")";
    }
    
    public String toString()
    {
        return ClassUtil.getShortClassName(this) + getDescription();
    }
}
