/*
 * Copyright 1999-2007 Christos KK Loverdos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ckkloverdos.version;

import org.ckkloverdos.log.StdLogger;

/**
 * Provides the version of the library.
 * Also it is the Main-Class of the library jar, so that when
 * the jar is executed, the version is printed.
 * 
 * @author Christos KK Loverdos
 */

public final class CkklCoreVersion
{
    private CkklCoreVersion()
    {
    }

    /**
     * Returns the library version or <code>null</code> if it cannot be determined.
     */
    public static String getVersion()
    {
        try
        {
            return CkklCoreVersion.class.getPackage().getImplementationVersion();
        }
        catch(Exception e)
        {
        }

        return null;
    }

    public static void main(String[] args)
    {
        StdLogger log = new StdLogger(null, "", false);
        try
        {
            Package p = CkklCoreVersion.class.getPackage();
            log.log(p.getImplementationTitle() + ", version " + p.getImplementationVersion());
        }
        catch(Exception e)
        {
            log.error("Could not determine version", e);
        }
    }
}
