{$IFDEF OVERLAY} {$O+} {$ENDIF}
unit news;


interface

procedure newsheader(wh:string);
procedure writenews(w:string;who:string);
procedure readnews(who:string);

implementation

uses files,global,datetime,strproc,fastio,mudmisc,showfile,output,input;

var
x,y:integer;
t:text;

procedure newsheader(wh:string);
begin
assign(t,resize(wh,8)+'.nws');
rewrite(t);
if wh='global' then write(t,header1) else write(t,header);
writeln(t,dtdatestring);
writeln(t,separator);
close(t);
end;

procedure writenews(w:string;who:string);
begin
if not fexists(resize(who,8)+'.nws') then newsheader(who);
assign(t,resize(who,8)+'.nws');
reset(t);
x:=0;
y:=0;
repeat
readln(t);
inc(x);
until eof(t);
if (trunc(x div 24)-y)>=1 then begin append(t); writeln(t,'%PA'); end;
append(t);
writeln(t,w);
writeln(t,separator);
close(t);
end;

procedure readnews(who:string);
begin
if not fexists(resize(who,8)+'.nws') then begin owrite('Sorry, no news...'); odnln(1); whpause; exit; end;
sfshowfile(resize(who,8)+'.nws',ftnormal);
if (who<>'global') and (who<>'yestday') then begin odnln(1); ocwrite('Delete personnal news? ');
if iyesno(true) then begin assign(t,resize(who,8)+'.nws'); erase(t); end;
end;
whpause;
end;
end.