program wearmcfg;

uses crt;

type

tweaparmflag = (mag1,mag2,mag3,mag4,mag5,cursed,fire,cold,ice,poison);

tweaponrec = record
 number:word;
 name:string[80];
 numberofdmgdice:word;
 dicetype:byte;
 flag:set of tweaparmflag;
 value:longint;
end;

tarmorrec = record
 number:word;
 name:string[80];
 acprot:byte;
 flag:set of tweaparmflag;
 value:longint;
end;

var armor:^tarmorrec; weapon:^tweaponrec; numweapon:word; numarmor:word;

procedure defaultweapon(n:word);
begin
 with weapon^ do begin
 number:=n;
 name:='Dummy Weapon';
 numberofdmgdice:=0;
 dicetype:=0;
 flag:=[];
 value:=0;      end;
end;

procedure defaultarmor(n:word);
begin
 with armor^ do begin
 number:=n;
 name:='Dummy Armor';
 acprot:=0;
 flag:=[];
 value:=0; end;
end;
procedure resetweapon;
begin
 write('Weapon.');
 fillchar(weapon^,sizeof(tweaponrec),#0);
 with weapon^ do begin
 number:=0;
 name:='Dummy Weapon';
 numberofdmgdice:=0;
 dicetype:=0;
 flag:=[];
 value:=0;      end;
writeln('end');
end;

procedure resetarmor;
begin
 write('Armor.');
 fillchar(armor^,sizeof(tarmorrec),#0);
{with armor^ do begin}
 armor^.number:=0;
 armor^.name:='Dummy Armor';
 armor^.acprot:=0;
 armor^.flag:=[];
 armor^.value:=0;
writeln('end');
end;

procedure armorAdd(var a : tarmorRec);
var F : file of tarmorRec;
    N : Word; T : tarmorrec; Done : Boolean;
begin
   Assign(F,'armors.dat');
   {$I-}
   Reset(F);
   {$I+}
   if ioResult <> 0 then
   begin
      a.Number := 1;
      Rewrite(F);
   end else
   begin
      N := 0;
      Done := False;
      while not Done do
      begin
         Read(F,T);
         Inc(N,1);
         Done := Eof(F);
      end;
      a.Number := N;
      if not Eof(F) then Seek(F,N-1) else a.Number := N+1;
   end;
   Write(F,a);
   numarmor := FileSize(F);
   Close(F);
end;

procedure weaponAdd(var w : tweaponRec);
var F : file of tweaponRec;
    N : Word; T : tweaponrec; Done : Boolean;
begin
   Assign(F,'weapons.dat');
   {$I-}
   Reset(F);
   {$I+}
   if ioResult <> 0 then
   begin
      w.Number := 1;
      Rewrite(F);
   end else
   begin
      N := 0;
      Done := False;
      while not Done do
      begin
         Read(F,T);
         Inc(N,1);
         Done := Eof(F);
      end;
      w.Number := N;
      if not Eof(F) then Seek(F,N-1) else w.Number := N+1;
   end;
   Write(F,w);
   numweapon:= FileSize(F);
   Close(F);
end;



procedure weaponSave(var w : tweaponRec);
var F : file;
begin
   if w.Number < 1 then Exit;
   Assign(F,'weapons.dat');
   {$I-}
   Reset(F,SizeOf(tweaponRec));
   {$I+}
   if ioResult <> 0 then weaponAdd(w) else
   begin
      Seek(F,w.Number-1);
      BlockWrite(F,w,1);
      Close(F);
   end;
end;

procedure armorSave(var a : tarmorRec);
var F : file;
begin
   if a.Number < 1 then Exit;
   Assign(F,'armors.dat');
   {$I-}
   Reset(F,SizeOf(tarmorRec));
   {$I+}
   if ioResult <> 0 then armorAdd(a) else
   begin
      Seek(F,a.Number-1);
      BlockWrite(F,a,1);
      Close(F);
   end;
end;


procedure weaponload(w:tweaponrec);
var F : file;
begin
   if W.Number < 1 then Exit;
   Assign(F,'weapons.dat');
   {$I-}
   Reset(F,SizeOf(tweaponRec));
   {$I+}
   if ioResult <> 0 then Exit;
   numWeapon := FileSize(F);
   Seek(F,w.Number-1);
   {$I-}
   BlockRead(F,w,1);
   {$I+}
   if ioresult <> 0 then defaultweapon(w.number);
   Close(F);
end;

procedure loadarmor(a:tarmorrec);
var F : file;
begin
   if a.Number < 1 then Exit;
   Assign(F,'armors.dat');
   {$I-}
   Reset(F,SizeOf(tarmorRec));
   {$I+}
   if ioResult <> 0 then Exit;
   numarmor := FileSize(F);
   Seek(F,a.Number-1);
   {$I-}
   BlockRead(F,a,1);
   {$I+}
   if ioresult <> 0 then defaultarmor(a.number);
   Close(F);
end;
{$I armo.PAS}
{$I weap.PAS}

procedure armorflags;
var ch:char; quit : boolean;
begin
quit:=false;
repeat
clrscr;
textcolor(15); write('['); textcolor(14); write('1'); textcolor(15); write(']');
write(' ');
if mag1 in armor^.flag then textcolor(15) else textcolor(8);writeln('+1 ');
textcolor(15); write('['); textcolor(14); write('2'); textcolor(15); write(']');
write(' ');
if mag2 in armor^.flag then textcolor(15) else textcolor(8);writeln('+2 ');
textcolor(15); write('['); textcolor(14); write('3'); textcolor(15); write(']');
write(' ');
if mag3 in armor^.flag then textcolor(15) else textcolor(8);writeln('+3 ');
textcolor(15); write('['); textcolor(14); write('4'); textcolor(15); write(']');
write(' ');
if mag4 in armor^.flag then textcolor(15) else textcolor(8);writeln('+4 ');
textcolor(15); write('['); textcolor(14); write('5'); textcolor(15); write(']');
write(' ');
if mag5 in armor^.flag then textcolor(15) else textcolor(8);writeln('+5 ');
textcolor(15); write('['); textcolor(14); write('A'); textcolor(15); write(']');
write(' ');
if cursed in armor^.flag then textcolor(15) else textcolor(8); writeln('cursed ');
textcolor(15); write('['); textcolor(14); write('B'); textcolor(15); write(']');
write(' ');
if fire in armor^.flag then textcolor(15) else textcolor(8);writeln('fire ');
textcolor(15); write('['); textcolor(14); write('C'); textcolor(15); write(']');
write(' ');
if cold in armor^.flag then textcolor(15) else textcolor(8); writeln('cold ');
textcolor(15); write('['); textcolor(14); write('D'); textcolor(15); write(']');
write(' ');
if ice in armor^.flag then textcolor(15) else textcolor(8); writeln('ice ');
textcolor(15); write('['); textcolor(14); write('E'); textcolor(15); write(']');
write(' ');
if poison in armor^.flag then textcolor(15) else textcolor(8);writeln('poison ');
textcolor(7);
writeln;
writeln('Enter the number/letter of the one to change, Q to end...');
repeat
ch:=readkey;
until upcase(ch) in ['1'..'5','A'..'E','Q'];
case upcase(ch) of
'1': begin
           if mag1 in armor^.flag then armor^.flag:=armor^.flag-[mag1] else
                                        armor^.flag:=armor^.flag+[mag1];
           if mag2 in armor^.flag then armor^.flag:=armor^.flag-[mag2];
           if mag3 in armor^.flag then armor^.flag:=armor^.flag-[mag3];
           if mag4 in armor^.flag then armor^.flag:=armor^.flag-[mag4];
           if mag5 in armor^.flag then armor^.flag:=armor^.flag-[mag5]; end;
'2': begin
           if mag2 in armor^.flag then armor^.flag:=armor^.flag-[mag2] else
                                        armor^.flag:=armor^.flag+[mag2];
           if mag1 in armor^.flag then armor^.flag:=armor^.flag-[mag1];
           if mag3 in armor^.flag then armor^.flag:=armor^.flag-[mag3];
           if mag4 in armor^.flag then armor^.flag:=armor^.flag-[mag4];
           if mag5 in armor^.flag then armor^.flag:=armor^.flag-[mag5];
end;
'3': begin
           if mag3 in armor^.flag then armor^.flag:=armor^.flag-[mag3] else
                                        armor^.flag:=armor^.flag+[mag3];
           if mag2 in armor^.flag then armor^.flag:=armor^.flag-[mag2];
           if mag1 in armor^.flag then armor^.flag:=armor^.flag-[mag1];
           if mag4 in armor^.flag then armor^.flag:=armor^.flag-[mag4];
           if mag5 in armor^.flag then armor^.flag:=armor^.flag-[mag5];
end;

'4': begin
           if mag4 in armor^.flag then armor^.flag:=armor^.flag-[mag4] else
                                        armor^.flag:=armor^.flag+[mag4];
           if mag2 in armor^.flag then armor^.flag:=armor^.flag-[mag2];
           if mag3 in armor^.flag then armor^.flag:=armor^.flag-[mag3];
           if mag1 in armor^.flag then armor^.flag:=armor^.flag-[mag1];
           if mag5 in armor^.flag then armor^.flag:=armor^.flag-[mag5];
end;

'5': begin
           if mag5 in armor^.flag then armor^.flag:=armor^.flag-[mag5] else
                                        armor^.flag:=armor^.flag+[mag5];
           if mag2 in armor^.flag then armor^.flag:=armor^.flag-[mag2];
           if mag3 in armor^.flag then armor^.flag:=armor^.flag-[mag3];
           if mag4 in armor^.flag then armor^.flag:=armor^.flag-[mag4];
           if mag1 in armor^.flag then armor^.flag:=armor^.flag-[mag1];
end;

'A': begin
           if cursed in armor^.flag then armor^.flag:=armor^.flag-[cursed] else
                                        armor^.flag:=armor^.flag+[cursed];
end;
'B': begin
           if fire in armor^.flag then armor^.flag:=armor^.flag-[fire] else
                                        armor^.flag:=armor^.flag+[fire];
end;
'C': begin
           if cold in armor^.flag then armor^.flag:=armor^.flag-[cold] else
                                        armor^.flag:=armor^.flag+[cold];
end;
'D': begin
           if ice in armor^.flag then armor^.flag:=armor^.flag-[ice] else
                                        armor^.flag:=armor^.flag+[ice];
end;
'E': begin
           if poison in armor^.flag then armor^.flag:=armor^.flag-[poison] else
                                        armor^.flag:=armor^.flag+[poison];
end;
'Q': quit:=true;
end;
until quit;
quit:=false;
end;

procedure editarmor;
var s:string; ch:char; quit:boolean; b:byte; y:integer;
begin;
quit:=false;
repeat
loadarmor(armor^);
clrscr;
move(armor_edit,mem[$b800:0000],1600); textcolor(15);
gotoxy(7,1); str(armor^.number,s); write(s); textcolor(7); write(' of ');
textcolor(15); str(numarmor,s); write(s);
gotoxy(16,3); write(armor^.name);
gotoxy(16,4); str(armor^.acprot,s); write(s);
gotoxy(16,5); textcolor(15);
if mag1 in armor^.flag then begin gotoxy(16,5); write('+1'); end;
if mag2 in armor^.flag then begin gotoxy(19,5); write('+2'); end;
if mag3 in armor^.flag then begin gotoxy(22,5); write('+3'); end;
if mag4 in armor^.flag then begin gotoxy(25,5); write('+4'); end;
if mag5 in armor^.flag then begin gotoxy(28,5); write('+5'); end;
if cursed in armor^.flag then begin gotoxy(31,5); write('cursed'); end;
if fire in armor^.flag then begin gotoxy(38,5); write('fire'); end;
if cold in armor^.flag then begin gotoxy(43,5); write('cold'); end;
if ice in armor^.flag then begin gotoxy(48,5); write('ice'); end;
if poison in armor^.flag then begin gotoxy(52,5); write('poison'); end;
gotoxy(16,6); str(armor^.value,s); write(s);
gotoxy(1,12); textcolor(15);write('[');textcolor(14);write('[');textcolor(15);write(']');
textcolor(14); write('Previous');
gotoxy(1,13); textcolor(15);write('[');textcolor(14);write(']');textcolor(15);write(']');
textcolor(14); write('Next');
repeat
ch:=readkey;
until upcase(ch) in ['N','A','F','V','[',']','R','S','Q'];
case upcase(ch) of
'N': begin gotoxy(15,3); write('____________________'); readln(armor^.name); end;
'A': begin readln(s); val(s,armor^.acprot,y); end;
'F': armorflags;
'V': begin readln(s); val(s,armor^.value,y); end;
'[': begin gotoxy(1,12); dec(armor^.number); if armor^.number=65535 then inc(armor^.number);
           loadarmor(armor^); end;
']': begin gotoxy(1,13); inc(armor^.number); if armor^.number=0 then dec(armor^.number);
           loadarmor(armor^); end;
'R': loadarmor(armor^);
'S': armorsave(armor^);
'Q': quit:=true;
end;
until quit;
end;

procedure resetarmorfile;
var f:file;
begin
with armor^ do begin
write('Reseting Armors..');
 assign(f,'armors.dat');
 reset(f);
 erase(f);
 close(f);
 number:=0;
 name:='No Armor';
 acprot:=0;
 flag:=[];
 value:=0;
armoradd(armor^);
 number:=1;
 name:='Leather Coat';
 acprot:=1;
 flag:=[];
 value:=2500;
armoradd(armor^); number:=2;
 name:='Ring Mail';
 acprot:=2;
 flag:=[];
 value:=5000;
armoradd(armor^); number:=3;
 name:='Scale Mail';
 acprot:=4;
 flag:=[];
 value:=10000;
armoradd(armor^); number:=4;
 name:='Chain Mail';
 acprot:=6;
 flag:=[];
 value:=15000;
armoradd(armor^); number:=5;
 name:='Splint Mail';
 acprot:=8;
 flag:=[];
 value:=30000;
armoradd(armor^); number:=6;
 name:='Bronze Plate Mail';
 acprot:=10;
 flag:=[];
 value:=40000;
armoradd(armor^); number:=7;
 name:='Plate Mail';
 acprot:=12;
 flag:=[];
 value:=50000;
armoradd(armor^); number:=8;
 name:='Field Plate';
 acprot:=13;
 flag:=[];
 value:=1000000;
armoradd(armor^); number:=9;
 name:='Full Plate';
 acprot:=14;
 flag:=[];
 value:=2000000;
armoradd(armor^); number:=10;
 name:='+2 Plate';
 acprot:=16;
 flag:=flag+[mag1];
 value:=9999999;
armoradd(armor^);   end;
end;

procedure resetweaponfile;
var f:file;
begin
with weapon^ do begin
write('Reseting Armors..');
 number:=0;
 name:='Fist';
 numberofdmgdice:=1;
 dicetype:=2;
 flag:=[];
 value:=0;
 weaponadd(weapon^);
 number:=2;
 name:='Dagger';
 numberofdmgdice:=1;
 dicetype:=4;
 flag:=[];
 value:=120;
 weaponadd(weapon^);
 number:=3;
 name:='Iron Staff';
 numberofdmgdice:=1;
 dicetype:=8;
 flag:=[];
 value:=210;
 weaponadd(weapon^);
 number:=4;
 name:='Short Sword';
 numberofdmgdice:=2;
 dicetype:=6;
 flag:=[];
 value:=1000;
 weaponadd(weapon^);
 number:=5;
 name:='Long Sword';
 numberofdmgdice:=3;
 dicetype:=6;
 flag:=[];
 value:=1500;
 weaponadd(weapon^);
 number:=6;
 name:='Battle Axe';
 numberofdmgdice:=3;
 dicetype:=8;
 flag:=[];
 value:=2000;
 weaponadd(weapon^);
 number:=7;
 name:='Two-Handed Sworg';
 numberofdmgdice:=3;
 dicetype:=12;
 flag:=[];
 value:=40000;
 weaponadd(weapon^);
 number:=8;
 name:='Bill-Guisarme';
 numberofdmgdice:=3;
 dicetype:=13;
 flag:=[];
 value:=50000;
 weaponadd(weapon^);
 number:=9;
 name:='Heavy Crossbow';
 numberofdmgdice:=2;
 dicetype:=6;
 flag:=[];
 value:=55000;
 weaponadd(weapon^);
 number:=10;
 name:='Venom Blade';
 numberofdmgdice:=5;
 dicetype:=20;
 flag:=flag+[poison,mag5];
 value:=9999999;
 weaponadd(weapon^);

end;

end;

procedure editweapon;
begin;
move(weapon_edit,mem[$b800:0000],1760);

end;

procedure menu1;
var ch:char;
begin
clrscr;
textcolor(14); write('A'); textcolor(13); writeln(' Armor editor');
textcolor(14); write('W'); textcolor(13); writeln(' Weapon editor');
writeln;
textcolor(14); write('R'); textcolor(13); writeln(' Reset to scratch');
textcolor(14); write('Q'); textcolor(13); writeln(' Quit, No Save!');
repeat
ch:=readkey;
until upcase(ch) in ['A','W','R','Q'];
case upcase(ch) of
'A': editarmor;
'W': editweapon;
'R': begin resetarmorfile; resetweapon; end;
'Q': halt(0);
end;
end;

begin
new(armor);
new(weapon);
resetarmor;
resetweapon;
loadarmor(armor^);
clrscr;
{menu1;}
resetarmorfile;
resetweaponfile;
dispose(armor);
dispose(weapon);
end.