/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class VMSTests
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: VMSTests.java,v 1.3 2007/03/02 07:10:18 bruceb Exp $";
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$test$VMSTests;

    protected String getLogName() {
        return "TestVMS.log";
    }

    public void testDir() throws Exception {
        block2: {
            this.connect();
            this.ftp.chdir(this.testdir);
            String[] list = this.ftp.dir();
            this.print(list);
            String randomName = this.generateRandomFilename();
            try {
                list = this.ftp.dir(randomName);
                this.print(list);
            }
            catch (FTPException ex) {
                if (ex.getReplyCode() == 550 || ex.getReplyCode() == 552) break block2;
                Assert.fail((String)("dir(" + randomName + ") should throw 550/552 for non-existent dir"));
            }
        }
        this.ftp.quit();
    }

    public void testDirFull() throws Exception {
        block2: {
            this.connect();
            this.ftp.chdir(this.testdir);
            String[] list = this.ftp.dir("", true);
            this.print(list);
            this.log.debug("******* dirDetails *******");
            FTPFile[] files = this.ftp.dirDetails("");
            this.print(files);
            this.log.debug("******* end dirDetails *******");
            String randomName = this.generateRandomFilename();
            try {
                list = this.ftp.dir(randomName, true);
                this.print(list);
            }
            catch (FTPException ex) {
                if (ex.getReplyCode() == 550 || ex.getReplyCode() == 552) break block2;
                Assert.fail((String)("dir(" + randomName + ") should throw 550/552 for non-existent dir"));
            }
        }
        this.ftp.quit();
    }

    public void testChangeDir() throws Exception {
        this.log.debug("testChangeDir");
        this.connect();
        this.ftp.chdir(this.testdir);
        String dir = this.getRemoteDirName();
        this.ftp.chdir(dir);
        this.ftp.cdup();
        this.ftp.quit();
    }

    public void testTransfer() throws Exception {
        this.log.debug("testTransfer");
        this.connect();
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.ASCII);
        String filename = this.generateRandomFilename();
        String remoteFile = this.getRemoteFileName();
        if (remoteFile == null) {
            remoteFile = this.remoteTextFile;
        }
        this.ftp.get(String.valueOf(this.localDataDir) + filename, remoteFile);
        this.ftp.setType(FTPTransferType.BINARY);
        this.ftp.get(String.valueOf(this.localDataDir) + filename, remoteFile);
        File local = new File(String.valueOf(this.localDataDir) + filename);
        local.delete();
        this.ftp.quit();
    }

    private String getRemoteFileName() throws IOException, FTPException, ParseException {
        FTPFile[] files = this.ftp.dirDetails("");
        String remoteFile = null;
        int i = 0;
        while (i < files.length) {
            if (files[i].getName().toUpperCase().endsWith(".TXT")) {
                remoteFile = files[i].getName();
                break;
            }
            ++i;
        }
        return remoteFile;
    }

    private String getRemoteDirName() throws IOException, FTPException, ParseException {
        FTPFile[] files = this.ftp.dirDetails("");
        String dir = null;
        int i = 0;
        while (i < files.length) {
            if (files[i].isDir()) {
                dir = files[i].getName();
                break;
            }
            ++i;
        }
        return dir;
    }

    public static Test suite() {
        return new TestSuite(class$com$enterprisedt$net$ftp$test$VMSTests != null ? class$com$enterprisedt$net$ftp$test$VMSTests : (class$com$enterprisedt$net$ftp$test$VMSTests = VMSTests.class$("com.enterprisedt.net.ftp.test.VMSTests")));
    }

    public static void main(String[] args) {
        TestRunner.run((Test)VMSTests.suite());
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

