/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPConnectMode;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Properties;
import junit.framework.TestCase;

public abstract class FTPTestCase
extends TestCase {
    private static String cvsId = "@(#)$Id$";
    protected PrintWriter log;
    protected FTPClient ftp;
    protected String host;
    protected String user;
    protected String password;
    protected FTPConnectMode connectMode;
    protected int timeout;
    protected String testdir;
    protected String remoteTextFile;
    protected String localTextFile;
    protected String remoteBinaryFile;
    protected String localBinaryFile;
    protected String localEmptyFile;
    protected String remoteEmptyFile;
    protected String remoteEmptyDir;
    protected String remotePopulatedDir;

    public FTPTestCase() {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream("test.properties"));
        }
        catch (IOException iOException) {
            System.out.println("Failed to open test.properties");
        }
        this.host = properties.getProperty("ftptest.host");
        this.user = properties.getProperty("ftptest.user");
        this.password = properties.getProperty("ftptest.password");
        String string = properties.getProperty("ftptest.connectmode");
        this.connectMode = string.equalsIgnoreCase("active") ? FTPConnectMode.ACTIVE : FTPConnectMode.PASV;
        String string2 = properties.getProperty("ftptest.timeout");
        this.timeout = Integer.parseInt(string2);
        this.testdir = properties.getProperty("ftptest.testdir");
        this.localTextFile = properties.getProperty("ftptest.file.local.text");
        this.remoteTextFile = properties.getProperty("ftptest.file.remote.text");
        this.localBinaryFile = properties.getProperty("ftptest.file.local.binary");
        this.remoteBinaryFile = properties.getProperty("ftptest.file.remote.binary");
        this.localEmptyFile = properties.getProperty("ftptest.file.local.empty");
        this.remoteEmptyFile = properties.getProperty("ftptest.file.remote.empty");
        this.remoteEmptyDir = properties.getProperty("ftptest.dir.remote.empty");
        this.remotePopulatedDir = properties.getProperty("ftptest.dir.remote.populated");
    }

    protected void connect() throws Exception {
        this.ftp = new FTPClient(this.host, 21);
        this.ftp.debugResponses(true);
        this.ftp.setLogStream(this.log);
    }

    protected String generateRandomFilename() {
        Date date = new Date();
        Long l = new Long(date.getTime());
        return l.toString();
    }

    protected abstract String getLogName();

    protected void login() throws Exception {
        this.ftp.login(this.user, this.password);
    }

    protected void setUp() throws Exception {
        this.log = new PrintWriter(new FileWriter(this.getLogName(), true));
    }

    protected void tearDown() throws Exception {
        this.log.close();
    }
}

