{
 $Id$
}
{*****************************************************************************
 *
 *  Process:  File area maintanence
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

unit fm_clean;   { clean a file area based on area.keepdays/keepamount }

{$O+} interface

uses dos, crt, s_string, f_file, fil_spec, crosslib,
     fm_struct, fm_basic, fm_log, nw_tpl, fm_exec;

procedure area_maint; { do the complete maintenance: read FM_$A_MA.INT,
                        clean every area in it, and delete the file... }

implementation

Type
  List = ^Element;

  Element = Record
    name : String[12];
    time : longint;
    Next : List;
  End;

Var
  Start,
  Current  : List;
  Count    : Integer;

procedure removedays;
var
  d1, d2 : longint;
  dt     : datetime;
  dummy  : word;
begin
  notifycr(6,'Deleting files older then '+int_to_str(area.keepdays)+' days...');

  Current := Start;
  While Current^.Next <> Nil do
    Begin
      if current^.time <> 0 then
        begin
          unpacktime(current^.time,dt);
          d1 := getunixdate(dt);
          With dt do
            begin
              GetTime (Hour, Min, Sec, Dummy);
              GetDate (Year, Month, Day, Dummy);
            end;
          d2 := getUnixDate(dt);
          d2 := d2 - d1;
          d2 := d2 div secsinaday;

          if d2 > area.keepdays then
            begin
              if setup.expandedlog then notify(6,'deleting '+current^.name+' ('+int_to_str(d2)+' days)');
              if not delete_file(area.directory+current^.name) then
                notifycr(6,' -> NOT FOUND ?!') else notifycr(6,'');

              dec(count);
            end;
        end;
      Current := Current^.Next;
    End;
end;

procedure removeamount;
var
  point : list;
  tel   : longint;
begin
  if count > area.keepamount then
    tel := count - area.keepamount else tel := 0;
  notifycr(6,'Deleting '+int_to_str(tel)+' oldest files...');

  if tel = 0 then exit;

  while count > area.keepamount do
    begin
      tel := 999999999;
      Current := Start;
      While Current^.Next <> Nil do
        Begin
          if (tel > current^.time) and (current^.time <> 0) then
            begin
              tel := current^.time;
              point := current;
            end;
          Current := Current^.Next;
        End;
      if setup.expandedlog then notify(6,'deleting '+point^.name);
      if not delete_file(area.directory+point^.name) then
        notifycr(6,' -> NOT FOUND ?!') else notifycr(6,'');
      point^.time := 0;
      point^.name := '';
      dec(count);
    end;
end;

procedure readdir(filesbbspath:string);
var
  sr : searchrec;
  nr : word;
begin
  New(Start);
  Current := Start;
  Current^.Next := Nil;
  Count := 0;

  nr := setup.filebase;
  if (area.areanr = 0) and (nr <> 0) then nr := 0; {filebase met files.bbs file}

  if nr <> 0 then getbbsareanaam(area.areanr);

  first_file(nr,filesbbspath,bbsarea,true);
  while not filelistend and (maxavail > 3000) do
    Begin
      if strip('A',' ',name_buffer) <> '' then
        begin
          Current^.name := name_buffer;
          if exist(area.directory+name_buffer) then
            begin
              findfirst(area.directory+name_buffer,anyfile,sr);
              Current^.time := sr.time;
              while doserror = 0 do findnext(sr);

              If maxavail > 3000 then
                begin
                  New(Current^.Next);
                  Current := Current^.Next;
                  Current^.Next := Nil;
                  Inc(count);
                end;
            end;
        end;
      next_file(nr,true);
    End;
  if maxavail <= 3000 then notifycr(2,'Out of memory');
End;

procedure do_maint(tmp:string);
var errorexec : word;
begin
  AFXinx := 0;
  While (AFXinx <= Areaidx) and (AFXt^[AFXinx].TAG <> tmp) do Inc(AFXinx);
  If AFXinx <= Areaidx then
    begin
      GetArea (AFXinx);
      notify(6,'Area: '+AFXt^[AFXinx].TAG+',');
      If Last(1,area.directory) <> '\' then area.directory := area.directory + '\';

      case setup.filebase of
       0 : tmp := area.directory+'FILES.BBS';
       1 : begin
             if area.areanr <> 0 then
               begin
                 Assign (BF, SystemPath + 'FILEAREA.FM');
                 {$I-} Reset (BF,1); {$I+}
                 If IOresult <> 0 then exit;
                 Seek(bf,20);               {eerste record lezen voor filebase path}
                 BlockRead(bF,Bbsarea,Sizeof(Bbsarea));
                 Close(bf);
                 If last(1,bbsarea.path) <> '\' then bbsarea.path := bbsarea.path + '\';
                 tmp := bbsarea.path;
               end else tmp := area.directory+'FILES.BBS';
           end;
      end;

      readdir(tmp);
      notifycr(6,' '+int_to_str(count)+' files.');

      If area.keepdays <> 0 then removedays;
      If area.keepamount <> 0 then removeamount;

      if start^.next <> nil then             { remove list from mem }
        begin
          repeat
            current := start;
            start := current^.next;
            dispose(current);
          until start^.next = nil;
        end;
      dispose(start);
      count := 0;

      case setup.filebase of      { remove deleted files from files.bbs/dbf }
        0 {filesbbs}  : begin
                          getdir(0,tmp);
                          chdir(first(length(area.directory)-1,area.directory));
                          writeln('changing dir to '+area.directory);

                          ErrorExec := 0;
                          ErrorExec := fmExec ('f:\qbbs\utils\wordwrap.exe', '', setup.swapmethode,
                             $3200, false, setup.showswapping);

                          chdir(tmp);
                        end;
        1 {rabase}    : begin
                        end;
      end;
    end;
end;

procedure area_maint;
var
  tmp : string;
begin
  if exist(systempath+'FM_$A_MA.INT') and exist(systempath+'FILEAREA.FM') then
    begin
      notifycr(12,'');
      notifycr(8,'Performing file area maintenance...');
      assign(tplfile,systempath+'FM_$A_MA.INT');
      {$I-} reset(tplfile); {$I+}
      if ioresult = 0 then
        begin
          while not eof(tplfile) do
            begin
              readln(tplfile,tmp);         {read area.tag}
              do_maint(tmp);               {perform maint}
            end;
          close(tplfile);
          erase(tplfile);
        end;
    end else
      if not exist(systempath+'FILEAREA.FM') then
        NotifyCR (2,'FILEAREA.FM not found. Please run FMCONV.EXE');
end;


end.
