PAGE  80,132
TITLE CHRPADR  String Pad Right Routine, Ver 6.20

; CHRPADR.ASM - ChrPadR
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine pads characters on the RIGHT  to fill out a field.
; If the field is smaller than the orginal string, the string is unaltered.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrPadR
        EXTRN   RepStosB: NEAR

S            EQU     DWORD PTR ss:[bx+8]
Fill         EQU     BYTE  PTR ss:[bx+6]
Field        EQU     BYTE  PTR ss:[bx+4]

; ChrPadR - Pad a string on the RIGHT to fill the field.
; procedure ChrPadR (S: string; Fill: char; Field: byte);

ChrPadR      PROC FAR
       mov   bx,sp            ; Set up stack base
; -- Get S --
       xor   ax,ax            ; Set AX=0
       les   di,S             ; Point to source string
       mov   al,es:[di]       ; Load S[0] in AL
       mov   cx,ax            ; Save length in CX
       mov   dx,ax            ; Save in DX, too
; -- Compare Field and length --
       mov   al,Field         ; Get proposed FIELD length
       sub   cx,ax            ; Length>=FIELD?
       jae   Exit             ;   yes, no padding possible
; -- Save new length --
       neg   cx               ; Make positive count
       cld                    ; Set DF to increment
       stosb                  ; Set new length
       add   di,dx            ; At S[L+1]
; -- Pad trailing chars --
       mov   al,Fill          ; Set AL to padding char
       call  RepStosB         ; Fast fill of trailing chars
Exit:  ret   8                ; Clear all parameters
ChrPadR      ENDP

CODE   ENDS

       END

