PAGE  80,132
TITLE CHRQTYI  Character Count and Position Routines - Ignore case, Ver 6.20

; CHRQTYI.ASM - ChrPosLI, ChrQtyI
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrQtyI, ChrSrchI

; Character search engine for ignore case routines.
; Enter with:
;  DS:SI pointing at first char to scan
;  DL    set to occurrences to scan
;  DF    set to direction
;  BX    set as base pointer

; Exit with:
;  BX = initial offset
;  SI = final offset
;  DL = down count of occurrences found
;  ZF altered (=1 for found; =0 for not found)
;  AL = 0 if ZF=0


Find         EQU     BYTE  PTR ss:[bx+6]

ChrSrchI     PROC  NEAR
       mov   al,Find          ; Get Find to scan
; -- Test if Find is Alphabetic --
ChrSrchQ:
       mov   ah,al            ; Also place Find in AH
       mov   bx,si            ; Save initial offset
       mov   dh,'a'-'A'       ; Set Case delta
       cmp   al,'z'           ; Find>'z'?
       ja    L6               ;   yes, non-alpha
       cmp   al,'a'           ; Find>'a'?
       jae   L1               ;   yes, lower case
       cmp   al,'A'           ; Find<'A'?
       jb    L6               ;   yes, non-alpha
       cmp   al,'Z'           ; Find>'Z'?
       ja    L6               ;   yes, non-alpha
       or    ah,dh            ; Convert to lower case
; -- Check alphabetic chars only --
       EVEN                   ; Align for speed
L1:    lodsb                  ; Get char
       or    al,dh            ; Ensure lower case
       xor   al,ah            ; All bits the same?
       je    L2               ;   yes, a match
       loop  L1               ; Loop for more
       ret                    ; Return to call
L2:    dec   dl               ; Adjust count
       loopnz L1              ; Loop if not (CX=0 or DL=0)
       ret                    ; Return to call

; -- Special case for non-alphabetic --
L6:    mov   di,ds            ; Move DS into
       mov   es,di            ;  ... ES
       mov   di,si            ; At S[index]
       EVEN                   ; Align for speed
L7:    repne scasb            ; Scan
       jne   ExitS            ; Not found
       dec   dl               ; Decrement Qty count
       jnz   L7               ; If not zero, find more
ExitS: mov   si,di            ; Save position in SI
       ret                    ; Return to call
ChrSrchI     ENDP



; ChrQtyI - Total quantity of chars in string ignoring case.
; This routine counts the occurrences of a given character in a string.
; function ChrQtyI (S: string; Find: char): byte;

S            EQU     DWORD PTR ss:[bx+6]
Find         EQU     BYTE  PTR ss:[bx+4]

ChrQtyI      PROC FAR
       mov   bx,sp            ; Set up stack base
       push  ds               ; Save Pascal's DS
; -- Point to string --
       xor   ax,ax            ; Set AX=0
       cwd                    ; Set DX=0 (count= 256)
       lds   si,S             ; Point to dest string
; -- Evaluate string length --
       cld                    ; Set DF to increment
       lodsb                  ; Get length
       mov   cx,ax            ; Set length
       jcxz  ExitQ            ; Quit if null string (ZF=0 for Pos)
; -- Test if Find is Alphabetic --
       mov   al,Find          ; Get Find to scan
       call  ChrSrchQ         ; Search for Find
       neg   dl               ; Change sign
       xchg  ax,dx            ; Place result in AX
ExitQ: pop   ds               ; Restore Pascal's DS
       ret   6                ; Clear all parameters
ChrQtyI      ENDP


CODE   ENDS

       END

