PAGE  80,132
TITLE CHRREPLI  Find and Replace of Char in String, Ignore case, Ver 6.20

; CHRREPLI.ASM - ChrReplI
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine finds and replaces a character from a given index for Qty
; number of replacements and IGNORES case.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrReplI

S            EQU     DWORD PTR [bp+14]
Find         EQU     BYTE  PTR [bp+12]
Repl         EQU     BYTE  PTR [bp+10]
Index        EQU     BYTE  PTR [bp+8]
Qty          EQU     BYTE  PTR [bp+6]

; ChrReplI - Finds and replace a character from a given index for Qty
; number of replacements ignoring case.
; procedure ChrReplI (VAR S: string; Find,Repl: char; Index,Qty: byte);

ChrReplI     PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       push  ds               ; Save Pascal's DS
       lds   si,S             ; Point to dest string
; -- Check S length --
       xor   ax,ax            ; Set AX=0
       cld                    ; Set DF to increment
       lodsb                  ; Get length
       mov   cx,ax            ; Also copy in CX
       jcxz  Exit             ; Quit if null string
; -- Check Index<=(Length(S) and Index>1 --
       mov   al,Index         ; Get Position
       cmp   ah,al            ; indeX<>0?
       sbb   al,ah            ;   yes, decrement
       sub   cx,ax            ; Chars to scan
       jbe   Exit             ; None to search
       add   si,ax            ; First char to scan
; -- Check Qty>0 --
       mov   al,Qty           ; Get quantity to replace
       test  al,al            ; Test value
       jz    Exit             ; If zero, then none to replace
       xchg  ax,dx            ; Save in DX
; -- Test if Find is Alphabetic --
       mov   al,Find          ; Get Find to scan
       mov   bl,Repl          ; Get char to replace
       mov   ah,al            ; Also place in AH
       mov   bh,'a'-'A'       ; Set conversion constant (20h)
       cmp   al,'z'           ; Find>'z'?
       ja    L6               ;   yes, non-alpha
       cmp   al,'a'           ; Find>'a'?
       jae   L1               ;   yes, lower case
       cmp   al,'A'           ; Find<'A'?
       jb    L6               ;   yes, non-alpha
       cmp   al,'Z'           ; Find>'Z'?
       ja    L6               ;   yes, non-alpha
       or    ah,bh            ; Convert to lower case
; -- Check alphabetic chars only --
       EVEN                   ; Align for speed
L1:    lodsb                  ; Get char
       or    al,bh            ; Ensure lower case
       xor   al,ah            ; All bits the same?
       je    L2               ;   yes, a match
       loop  L1               ; Loop for more
       jmp   SHORT Exit       ;
L2:    mov   [si-1],bl        ; Store Repl
       dec   dl               ; Adjust count
       loopnz L1              ; Loop if not (CX=0 or DL=0)
Exit:  pop   ds               ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret   12               ; Clear all parameters

; -- Special case for non-alphabetic --
L6:    mov   di,ds            ; Move DS into
       mov   es,di            ;  ... ES
       mov   di,si            ; At S[index]
       EVEN                   ; Align for speed
L7:    repne scasb            ; Scan        (ZF=0 after first time)
       jne   Exit             ; Not found
       mov   [di-1],bl        ; Replace character
       dec   dx               ; Decrement Qty count
       jnz   L7               ; If not zero, replace more
       jmp   SHORT Exit       ; All done

ChrReplI     ENDP

CODE   ENDS

       END
