PAGE  80,132
TITLE DELETE  String Delete Routine, Ver 6.20

; DELETE.ASM - Delete
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine replaces Pascal's slow Delete routine.  It automatically
; replaces the routine when used.  This matches the peculiarities the
; standard routine when the index is 0 - it deletes an additional character.
; Negative values all also matched.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  Delete
        EXTRN   RepMovsB: NEAR

S            EQU     DWORD PTR [bp+10]
Index        EQU     WORD  PTR [bp+8]
Count        EQU     WORD  PTR [bp+6]

; Delete - Deletes an array of characters in a string.
; procedure Delete (S: string; Index,Count: integer);

; Quit if:
;   Count=0
;   Length=0
;   Index>Length
; Append chars = Max (Length - (Index + Count),0)
; New Length   = Index + Append chars

Delete       PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       push  ds               ; Save Pascal's DS
; -- Check S length --
       lds   si,S             ; Point to source string
       xor   ax,ax            ; Set AX=0
       cwd                    ; Set DX=0
       cld                    ; Set DF to increment
       lodsb                  ; Get length  (SI+1)
       mov   cx,ax            ; Save in CX
;      jcxz  @@4              ;  -- Wait for JLE below
       mov   di,si            ; Copy offset
; -- Check Index>Length --
       mov   ax,Index         ; Get index
       dec   ax               ; Index-1
       jns   @@1              ; Jump if Index was >0
                              ;  if Index was -32768 it becomes 32767.  so
                              ;  it will jump, but SUB CX,AX will prove to
                              ;  be neg and will exit routine.  It is
                              ;  impossible to delete anything at that index.
       xchg  ax,dx            ; AX=0 and DX=negative
@@1:   sub   cx,ax            ; Index>Length?  (CX=Trailing length)
       jle   @@4              ;   yes, all done
       add   di,ax            ; Destination offset
       mov   bx,ax            ; Save vulnerable length BX
; -- Check Count>0 and any appending chars to move --
       mov   ax,Count         ; Get Count
       add   ax,dx            ; Subtract if Index was <=0
       jle   @@4              ; Quit if nothing to delete
       sub   cx,ax            ; Trailing chars to concat?
       jg    @@2              ;   yes, characters to append
       xor   cx,cx            ;   no, just truncate
@@2:   add   bx,cx            ; New length in BX
; -- Store new length --
       mov   [si-1],bl        ; Save new length
; -- Append trailing chars --
       jcxz  @@4              ; No appending chars
       mov   bx,ds            ; Mov seg DS ...
       mov   es,bx            ;   to ES
       mov   si,di            ; Point to S[Index]
       add   si,ax            ; Point to S[Index+Count]
       call  RepMovsB         ; Do fast move of bytes
@@4:   pop   ds               ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       retf  8                ; Clear all parameters
Delete       ENDP

CODE   ENDS

       END
