PAGE  80,132
TITLE STRLN  Ln to String Routine, Ver 6.20

; STRLN.ASM - StrLn
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine converts text file strings (ending with CR/LF or CR) to Pascal
; type strings.


DATA    SEGMENT WORD PUBLIC
        EXTRN   LnSrcPtr: WORD
DATA    ENDS

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE, DS:DATA
        PUBLIC  StrLn
        EXTRN   RepMovsBRev: NEAR

Dest         EQU     DWORD PTR [bp+12]
LnSrc        EQU     DWORD PTR [bp+8]
MaxLen       EQU     BYTE  PTR [bp+6]
EOS          EQU     BYTE  PTR ES:[di]

; StrLn - Converts ASCII TEXT strings that end with CR/LF or CR to Pascal
; string.  Source and destination can be the same.  This is a move-like
; procedure - make sure the destination size is sufficient to fit the source.
; LnSrcPtr is great for sequential processing.  After StrLn is executed,
; LnSrcPtr is set to the next source char or after the CR/LF or CR.

; procedure StrLn (VAR Dest: string; VAR LnSrc);

StrLn        PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       mov   dx,ds            ; Save Pascal's DS
; -- Scan for CR --
       les   di,LnSrc         ; Point to source string
       xor   bx,bx            ; Set BX=0
       mov   bl,MaxLen        ; Set BL to MaxLen
       inc   bx               ; Scan past #13
       mov   cx,bx            ; Copy to CX
       mov   al,13            ; Set AL=CR
       cld                    ; Set DF to increment
       repne scasb            ; Search for CR
; -- Point LnSrcPtr after CR/LF, CR, or at next char --
       mov   si,di            ; Move to source
       je    GotCR            ; Jump if CR found
       dec   di               ; Decrement if no CR
       jmp   SHORT NoEnd      ;
; -- Check for LF, too. --
GotCR: cmp   EOS,10           ; Linefeed, too?
       jne   NoEnd            ;   no, no line feed
       inc   di               ;   yes, skip it
NoEnd: mov   LnSrcPtr,di      ; Save Ofs of LnSrcPtr
; -- Calc char length --
       sub   bx,cx            ; Chars scanned
       dec   bx               ; String length
       mov   cx,bx            ; Set count
; -- Point to last LN char --
       dec   si               ; Point to CR
       dec   si               ; Point to last char
       mov   ax,es            ; Get seg
       mov   LnSrcPtr+2,ax    ; Save Seg of LnSrcPtr
       mov   ds,ax            ; Set source seg
; -- Point to last S char --
       les   di,Dest          ; Point to dest Pascal string
       add   di,bx            ; Offset to last char
       std                    ; Set DF to decrement
       call  RepMovsBRev      ; Do fast move of bytes in reverse
       xchg  ax,bx            ; Put string length in AL
       stosb                  ; Save length
       mov   ds,dx            ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret   10               ; Clear all parameters
StrLn        ENDP

CODE   ENDS

       END
