PAGE  80,132
TITLE VALBIN  Binary String to Decimal Routine, Ver 6.20

; VALBIN.ASM - ValBin
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine converts binary strings to longint.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ValBin

Sofs         EQU     WORD  PTR [bp+10]
S            EQU     DWORD PTR [bp+10]
ErrCode      EQU     DWORD PTR [bp+6]
Place        EQU     BYTE  PTR [SI]


; ValBin - Converts binary strings to a longint.
;  . Leading spaces are permitted but not trailing ones.
;  . Leading zeros are also permitted.
;  . A non-zero error code points to the invalid character in the string.
;  . Numbers larger than $FFFFFFFF produce an error.
;  . ValBin salvages a value even if there is an error.
;  . Routine is more flexible as a function rather than being similar to the
;    System.Val procedure which is compiler dependent on the number type.
;
; function ValBin (S: string; VAR Code: integer): longint;

ValBin       PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       push  ds               ; Save Pascal's DS
       lds   si,S             ; Point at S
       xor   ax,ax            ; Set AX=0
       cwd                    ; Set DX=0
       mov   bx,ax            ; Set BX=0
       cld                    ; Set DF to increment
       lodsb                  ; Get length in AL
       xchg  ax,cx            ; Place length in CX
       jcxz  Exit2            ; Exit if no length
; -- Skip leading spaces --
       EVEN                   ; Align for speed
L0:    cmp   Place,' '        ; Place char = space?
       jne   Next             ;   no, must be char
       inc   si               ; Go to next char
       loop  L0               ; Try again
       jmp   SHORT Exit2      ; Exit, no char found
; -- Calculate error position --
Exit1: dec   si               ; Point to bad char
Exit2: xchg  ax,si            ; Get offset
       sub   ax,Sofs          ; Calc bad position
       jmp   SHORT Exit3      ;
; -- Evaluate chars --
Next:  mov   ah,'1'           ; Set AL to one
       EVEN                   ; Align for speed
L1:    lodsb                  ; Get char
       cmp   al,ah            ; =1?
       stc                    ; Set carry flag
       je    L2               ;   yes, set bit
       cmp   al,'0'           ; =0?
       clc                    ; Clear carry flag
       jne   Exit1            ; Bad char
L2:    rcl   bx,1             ; Shift bits
       rcl   dx,1             ; Shift bits
       jc    Exit1            ; Exit if Val>$FFFFFFFF
       loop  L1               ;
       xchg  ax,cx            ; Nullify error code AX=0
; -- Set results --
Exit3: les   di,ErrCode       ; Point to ErrCode
       stosw                  ; Save ErrCode
       xchg  ax,bx            ; Place BX in AX
       pop   ds               ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret   8                ; Clear all parameters
ValBin       ENDP

CODE   ENDS

       END
