/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.access.simpleACL;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.access.AccessService;
import net.jxta.credential.Credential;
import net.jxta.credential.PrivilegedOperation;
import net.jxta.document.Advertisement;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.TextElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.service.Service;

public class SimpleACLAccessService
implements AccessService {
    private static final Logger LOG = Logger.getLogger(SimpleACLAccessService.class.getName());
    public static final ModuleSpecID simpleACLAccessSpecID = (ModuleSpecID)ID.create(URI.create("urn:jxta:uuid-DeadBeefDeafBabaFeedBabe000000100206"));
    PeerGroup group;
    ModuleImplAdvertisement implAdvertisement;
    private final Map<String, Set<String>> ACLs = new HashMap<String, Set<String>>();

    public void init(PeerGroup group, ID assignedID, Advertisement implAdv) throws PeerGroupException {
        PeerGroupAdvertisement configAdv;
        TextElement myParam;
        this.group = group;
        this.implAdvertisement = (ModuleImplAdvertisement)implAdv;
        if (Logging.SHOW_CONFIG && LOG.isLoggable(Level.CONFIG)) {
            StringBuilder configInfo = new StringBuilder("Configuring Access Service : " + assignedID);
            configInfo.append("\n\tImplementation:");
            configInfo.append("\n\t\tImpl Description: " + this.implAdvertisement.getDescription());
            configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
            configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            configInfo.append("\n\tGroup Params:");
            configInfo.append("\n\t\tGroup: " + group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID: " + group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID: " + group.getPeerID());
            LOG.config(configInfo.toString());
        }
        if (null == (myParam = (TextElement)((Object)(configAdv = group.getPeerGroupAdvertisement()).getServiceParam(assignedID)))) {
            throw new PeerGroupException("parameters for group access controls missing.");
        }
        Enumeration allACLS = myParam.getChildren();
        while (allACLS.hasMoreElements()) {
            String etcPasswd;
            int nextDelim;
            TextElement anACL = (TextElement)allACLS.nextElement();
            if (!anACL.getName().equals("perm") || -1 == (nextDelim = (etcPasswd = anACL.getTextValue()).indexOf(58))) continue;
            String operation = etcPasswd.substring(0, nextDelim).trim();
            if ("<<DEFAULT>>".equals(operation)) {
                operation = null;
            }
            String identities = etcPasswd.substring(nextDelim + 1);
            HashSet<String> allowed = new HashSet<String>();
            StringTokenizer eachIdentity = new StringTokenizer(identities, ",");
            while (eachIdentity.hasMoreTokens()) {
                String anIdentity = eachIdentity.nextToken().trim();
                if ("<<ALL>>".equals(anIdentity)) {
                    anIdentity = null;
                }
                allowed.add(anIdentity);
            }
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Adding operation  : '" + (null == operation ? "<<DEFAULT>>" : operation) + "' with " + allowed.size() + " identities.");
            }
            this.ACLs.put(operation, allowed);
        }
    }

    public int startApp(String[] args) {
        return 0;
    }

    public void stopApp() {
    }

    public ModuleImplAdvertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public SimpleACLAccessService getInterface() {
        return this;
    }

    public AccessService.AccessResult doAccessCheck(PrivilegedOperation op, Credential cred) {
        if (null != cred && !cred.isValid()) {
            return AccessService.AccessResult.DISALLOWED;
        }
        if (null != op && !op.isValid()) {
            return AccessService.AccessResult.DISALLOWED;
        }
        Set<String> allowed = this.ACLs.get(null != op ? op.getSubject() : null);
        if (null == allowed && null == (allowed = this.ACLs.get(null))) {
            return AccessService.AccessResult.DISALLOWED;
        }
        String credSubject = null != cred ? cred.getSubject().toString() : null;
        return allowed.contains(credSubject) || allowed.contains(null) ? AccessService.AccessResult.PERMITTED : AccessService.AccessResult.DISALLOWED;
    }

    public PrivilegedOperation newPrivilegedOperation(Object subject, Credential offerer) {
        if (!(subject instanceof String)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports String subjects.");
        }
        if (!offerer.isValid()) {
            throw new IllegalArgumentException("offerer is not a valid credential");
        }
        return new SimpleACLOperation(this, (String)subject, offerer);
    }

    public PrivilegedOperation newPrivilegedOperation(Element source) {
        return new SimpleACLOperation(this, source);
    }

    PeerGroup getPeerGroup() {
        return this.group;
    }

    private static class SimpleACLOperation
    implements PrivilegedOperation {
        SimpleACLAccessService source;
        String op;
        Credential offerer;

        protected SimpleACLOperation(SimpleACLAccessService source, String op, Credential offerer) {
            this.source = source;
            this.op = op;
            this.offerer = offerer;
        }

        protected SimpleACLOperation(SimpleACLAccessService source, Element root) {
            this.source = source;
            this.initialize(root);
        }

        public ID getPeerGroupID() {
            return this.source.getPeerGroup().getPeerGroupID();
        }

        public ID getPeerID() {
            return null;
        }

        public boolean isExpired() {
            return false;
        }

        public boolean isValid() {
            return true;
        }

        public String getSubject() {
            return this.op;
        }

        public Service getSourceService() {
            return this.source;
        }

        public StructuredDocument getDocument(MimeMediaType as) throws Exception {
            StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(as, "jxta:Cred");
            if (doc instanceof Attributable) {
                ((Attributable)((Object)doc)).addAttribute("xmlns:jxta", "http://jxta.org");
                ((Attributable)((Object)doc)).addAttribute("xml:space", "preserve");
                ((Attributable)((Object)doc)).addAttribute("type", "jxta:SimpleACLOp");
            }
            Object e = doc.createElement("PeerGroupID", this.getPeerGroupID().toString());
            doc.appendChild(e);
            e = doc.createElement("Operation", this.op);
            doc.appendChild(e);
            StructuredDocumentUtils.copyElements(doc, doc, this.offerer.getDocument(as), "Offerer");
            return doc;
        }

        public Credential getOfferer() {
            return this.offerer;
        }

        protected boolean handleElement(TextElement elem) {
            if (elem.getName().equals("PeerGroupID")) {
                try {
                    URI gID = new URI(elem.getTextValue().trim());
                    ID pgid = IDFactory.fromURI(gID);
                    if (!pgid.equals(this.getPeerGroupID())) {
                        throw new IllegalArgumentException("Operation is from a different group. " + pgid + " != " + this.getPeerGroupID());
                    }
                }
                catch (URISyntaxException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement: " + elem.getTextValue());
                }
                catch (ClassCastException badID) {
                    throw new IllegalArgumentException("Id is not a group id: " + elem.getTextValue());
                }
                return true;
            }
            if (elem.getName().equals("Operation")) {
                this.op = elem.getTextValue();
                return true;
            }
            if (elem.getName().equals("Offerer")) {
                try {
                    this.offerer = this.source.getPeerGroup().getMembershipService().makeCredential(elem);
                }
                catch (Throwable failed) {
                    throw new IllegalArgumentException("Offerer credential could not be constructed" + failed);
                }
                return true;
            }
            return false;
        }

        protected void initialize(Element root) {
            String doctype;
            Attribute itsType;
            if (!TextElement.class.isInstance(root)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
            }
            TextElement doc = (TextElement)root;
            String typedoctype = "";
            if (root instanceof Attributable && null != (itsType = ((Attributable)((Object)root)).getAttribute("type"))) {
                typedoctype = itsType.getValue();
            }
            if (!(doctype = doc.getName()).equals("jxta:SimpleACLOp") && !typedoctype.equals("jxta:SimpleACLOp")) {
                throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
            }
            Enumeration elements = doc.getChildren();
            while (elements.hasMoreElements()) {
                TextElement elem = (TextElement)elements.nextElement();
                if (this.handleElement(elem) || !Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("Unhandled element '" + elem.getName() + "' in " + doc.getName());
            }
            if (null == this.op) {
                throw new IllegalArgumentException("operation was never initialized.");
            }
            if (null == this.offerer) {
                throw new IllegalArgumentException("offerer was never initialized.");
            }
        }
    }
}

