/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.XMLElement;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

public final class EndpointUtils {
    private static final transient Logger LOG = Logger.getLogger(EndpointUtils.class.getName());

    public static RouteAdvertisement extractRouteAdv(PeerAdvertisement adv) {
        try {
            XMLElement endpParam = (XMLElement)((Object)adv.getServiceParam(PeerGroup.endpointClassID));
            if (endpParam == null) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("No Endpoint Params");
                }
                return null;
            }
            Enumeration paramChilds = endpParam.getChildren(RouteAdvertisement.getAdvertisementType());
            if (!paramChilds.hasMoreElements()) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.fine("No Route Adv in Peer Adv");
                }
                return null;
            }
            XMLElement param = (XMLElement)paramChilds.nextElement();
            RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(param);
            route.setDestPeerID(adv.getPeerID());
            return route;
        }
        catch (Exception e) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "failed to extract radv", e);
            }
            return null;
        }
    }
}

