/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.endpointMeter;

import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.endpointMeter.InboundMetric;

public class InboundMeter {
    private String serviceName;
    private String serviceParameter;
    private InboundMetric totals;
    private InboundMetric delta;

    public InboundMeter(String serviceName, String serviceParameter) {
        this.serviceName = serviceName;
        this.serviceParameter = serviceParameter;
        this.totals = new InboundMetric(this);
    }

    private void createDeltaMetric() {
        this.delta = new InboundMetric(this);
    }

    public void inboundMessageQueued(Message message) {
        if (this.delta == null) {
            this.createDeltaMetric();
        }
        this.delta.inboundMessageQueued(message);
        this.totals.inboundMessageQueued(message);
    }

    public void inboundMessageDropped(Message message, long time) {
        if (this.delta == null) {
            this.createDeltaMetric();
        }
        this.delta.inboundMessageDropped(message, time);
        this.totals.inboundMessageDropped(message, time);
    }

    public void inboundMessageDeQueued(Message message, long time) {
        if (this.delta == null) {
            this.createDeltaMetric();
        }
        this.delta.inboundMessageDeQueued(message, time);
        this.totals.inboundMessageDeQueued(message, time);
    }

    public void inboundMessageProcessed(Message message, long time) {
        if (this.delta == null) {
            this.createDeltaMetric();
        }
        this.delta.inboundMessageProcessed(message, time);
        this.totals.inboundMessageProcessed(message, time);
    }

    String getServiceName() {
        return this.serviceName;
    }

    String getServiceParameter() {
        return this.serviceParameter;
    }

    public String toString() {
        return "InboundMeter(" + this.serviceName + "//" + this.serviceParameter + ")";
    }

    public InboundMetric getCumulativeMetrics() {
        return this.totals;
    }

    public synchronized InboundMetric collectMetrics() {
        InboundMetric prevDelta = this.delta;
        this.delta = null;
        return prevDelta;
    }
}

