/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.endpointMeter;

import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.endpointMeter.OutboundMetric;

public class OutboundMeter {
    private EndpointAddress endpointAddress;
    private OutboundMetric totals;
    private OutboundMetric delta;

    public OutboundMeter(EndpointAddress endpointAddress) {
        this.endpointAddress = endpointAddress;
        this.totals = new OutboundMetric(this);
    }

    private void createDeltaMetric() {
        this.delta = new OutboundMetric(this);
    }

    public void outboundMessageQueued(Message message) {
        if (this.delta == null) {
            this.createDeltaMetric();
        }
        this.delta.outboundMessageQueued(message);
        this.totals.outboundMessageQueued(message);
    }

    public void outboundMessageDropped(Message message, long time) {
        if (this.delta == null) {
            this.createDeltaMetric();
        }
        this.delta.outboundMessageDropped(message, time);
        this.totals.outboundMessageDropped(message, time);
    }

    public void outboundMessageFailed(Message message, long time) {
        if (this.delta == null) {
            this.createDeltaMetric();
        }
        this.delta.outboundMessageFailed(message, time);
        this.totals.outboundMessageFailed(message, time);
    }

    public void outboundMessageDeQueued(Message message, long time) {
        if (this.delta == null) {
            this.createDeltaMetric();
        }
        this.delta.outboundMessageDeQueued(message, time);
        this.totals.outboundMessageDeQueued(message, time);
    }

    public void outboundMessageProcessed(Message message, long time) {
        if (this.delta == null) {
            this.createDeltaMetric();
        }
        this.delta.outboundMessageProcessed(message, time);
        this.totals.outboundMessageProcessed(message, time);
    }

    EndpointAddress getEndpointAddress() {
        return this.endpointAddress;
    }

    public String toString() {
        return "OutboundMeter(" + this.endpointAddress + ")";
    }

    public OutboundMetric getCumulativeMetrics() {
        return this.totals;
    }

    public synchronized OutboundMetric collectMetrics() {
        OutboundMetric prevDelta = this.delta;
        this.delta = null;
        return prevDelta;
    }
}

