/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.XMLElement;
import net.jxta.logging.Logging;
import net.jxta.protocol.TransportAdvertisement;

public class HTTPAdv
extends TransportAdvertisement {
    private static final Logger LOG = Logger.getLogger(HTTPAdv.class.getName());
    private static final String[] CONFIGMODES = new String[]{"auto", "manual"};
    private static final String[] INDEXFIELDS = new String[0];
    private static final String ProtocolTag = "Protocol";
    private static final String ProxyTag = "Proxy";
    private static final String ServerTag = "Server";
    private static final String PortTag = "Port";
    private static final String IntfAddrTag = "InterfaceAddress";
    private static final String ConfModeTag = "ConfigMode";
    private static final String FlagsTag = "Flags";
    private static final String PublicAddressOnlyAttr = "PublicAddressOnly";
    private static final String ProxyOffTag = "ProxyOff";
    private static final String ServerOffTag = "ServerOff";
    private static final String ClientOffTag = "ClientOff";
    private String proxy = null;
    private String server = null;
    private int listenPort = -1;
    private String interfaceAddress = null;
    private String configMode = CONFIGMODES[0];
    private boolean publicAddressOnly = false;
    private boolean proxyEnabled = true;
    private boolean serverEnabled = true;
    private boolean clientEnabled = true;

    public static String getAdvertisementType() {
        return "jxta:HTTPTransportAdvertisement";
    }

    private HTTPAdv() {
    }

    private HTTPAdv(XMLElement doc) {
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(HTTPAdv.getAdvertisementType()) && !HTTPAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Attribute attr = doc.getAttribute(FlagsTag);
        if (attr != null) {
            String options = attr.getValue();
            this.publicAddressOnly = options.indexOf(PublicAddressOnlyAttr) != -1;
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Unhandled Element: " + elem.toString());
        }
        if (this.proxy == null) {
            this.proxyEnabled = false;
        }
        if (this.serverEnabled && 0 == this.listenPort) {
            throw new IllegalArgumentException("Dynmaic port selection not supported with incoming connections.");
        }
        if (this.listenPort < -1 || this.listenPort > 65535) {
            throw new IllegalArgumentException("Illegal Listen Port Value");
        }
        if (!Arrays.asList(CONFIGMODES).contains(this.configMode)) {
            throw new IllegalArgumentException("Unsupported configuration mode.");
        }
        if (null == this.getProtocol()) {
            this.setProtocol("http");
        }
    }

    public String getAdvType() {
        return HTTPAdv.getAdvertisementType();
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        String tag = elem.getName();
        if (tag.equals(ProxyOffTag)) {
            this.proxyEnabled = false;
            return true;
        }
        if (tag.equals(ServerOffTag)) {
            this.serverEnabled = false;
            return true;
        }
        if (tag.equals(ClientOffTag)) {
            this.clientEnabled = false;
            return true;
        }
        String value = elem.getTextValue();
        if (null == value) {
            return false;
        }
        if (0 == (value = value.trim()).length()) {
            return false;
        }
        if (tag.equals(ProtocolTag)) {
            this.setProtocol(value);
            return true;
        }
        if (tag.equals(IntfAddrTag)) {
            this.setInterfaceAddress(value);
            return true;
        }
        if (tag.equals(ConfModeTag)) {
            this.setConfigMode(value);
            return true;
        }
        if (tag.equals(PortTag)) {
            this.setPort(Integer.parseInt(value.trim()));
            return true;
        }
        if (tag.equals(ProxyTag)) {
            this.proxy = value;
            return true;
        }
        if (tag.equals(ServerTag)) {
            this.server = value;
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        Object ext;
        StructuredDocument adv;
        if (this.serverEnabled && 0 == this.listenPort) {
            throw new IllegalStateException("Dynmaic port selection not supported with incoming connections.");
        }
        if (this.listenPort < -1 || this.listenPort > 65535) {
            throw new IllegalStateException("Illegal Listen Port Value");
        }
        if (!Arrays.asList(CONFIGMODES).contains(this.configMode)) {
            throw new IllegalStateException("Unsupported configuration mode.");
        }
        if (null == this.getProtocol()) {
            this.setProtocol("http");
        }
        if ((adv = (StructuredDocument)super.getDocument(encodeAs)) instanceof Attributable && this.publicAddressOnly) {
            ((Attributable)((Object)adv)).addAttribute(FlagsTag, PublicAddressOnlyAttr);
        }
        Object e1 = adv.createElement(ProtocolTag, this.getProtocol());
        adv.appendChild(e1);
        if (null != this.getInterfaceAddress()) {
            Object e2 = adv.createElement(IntfAddrTag, this.getInterfaceAddress());
            adv.appendChild(e2);
        }
        Object e3 = adv.createElement(ConfModeTag, this.getConfigMode());
        adv.appendChild(e3);
        Object e4 = adv.createElement(PortTag, Integer.toString(this.getPort()));
        adv.appendChild(e4);
        if (this.proxy != null) {
            ext = adv.createElement(ProxyTag, this.proxy);
            adv.appendChild(ext);
        }
        if (!this.proxyEnabled) {
            ext = adv.createElement(ProxyOffTag);
            adv.appendChild(ext);
        }
        if (this.server != null) {
            ext = adv.createElement(ServerTag, this.server);
            adv.appendChild(ext);
        }
        if (!this.serverEnabled) {
            ext = adv.createElement(ServerOffTag);
            adv.appendChild(ext);
        }
        if (!this.clientEnabled) {
            ext = adv.createElement(ClientOffTag);
            adv.appendChild(ext);
        }
        return adv;
    }

    public String getInterfaceAddress() {
        return this.interfaceAddress;
    }

    public void setInterfaceAddress(String address) {
        this.interfaceAddress = address;
    }

    public boolean getPublicAddressOnly() {
        return this.publicAddressOnly;
    }

    public void setPublicAddressOnly(boolean only) {
        this.publicAddressOnly = only;
    }

    public String getConfigMode() {
        return this.configMode;
    }

    public void setConfigMode(String mode) {
        if (!Arrays.asList(CONFIGMODES).contains(mode)) {
            throw new IllegalArgumentException("Unsupported configuration mode.");
        }
        this.configMode = mode;
    }

    public int getPort() {
        return this.listenPort;
    }

    public void setPort(int newPort) {
        this.listenPort = newPort;
    }

    @Deprecated
    public String getProxy() {
        return this.proxy;
    }

    public String getServer() {
        return this.server;
    }

    @Deprecated
    public boolean isProxyEnabled() {
        return this.proxyEnabled;
    }

    public boolean isServerEnabled() {
        return this.serverEnabled;
    }

    public boolean isClientEnabled() {
        return this.clientEnabled;
    }

    @Deprecated
    public void setProxy(String name) {
        this.proxy = name;
        if (name == null) {
            this.proxyEnabled = false;
        }
    }

    public void setServer(String name) {
        this.server = name;
    }

    @Deprecated
    public void setProxyEnabled(boolean enabled) {
        this.proxyEnabled = enabled;
    }

    public void setServerEnabled(boolean enabled) {
        this.serverEnabled = enabled;
    }

    public void setClientEnabled(boolean enabled) {
        this.clientEnabled = enabled;
    }

    public String[] getIndexFields() {
        return INDEXFIELDS;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return HTTPAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new HTTPAdv();
        }

        public Advertisement newInstance(Element root) {
            if (!XMLElement.class.isInstance(root)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
            }
            return new HTTPAdv((XMLElement)root);
        }
    }
}

