/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attributable;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;
import net.jxta.pipe.PipeID;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeResolverMessage;

public class PipeResolverMsg
extends PipeResolverMessage {
    private static final transient Logger LOG = Logger.getLogger(PipeResolverMsg.class.getName());
    private static final String MsgTypeTag = "MsgType";
    private static final String PipeIdTag = "PipeId";
    private static final String PipeTypeTag = "Type";
    private static final String PeerIdTag = "Peer";
    private static final String PeerAdvTag = "PeerAdv";
    private static final String FoundTag = "Found";
    private static final String QueryMsgType = "Query";
    private static final String AnswerMsgType = "Answer";

    public PipeResolverMsg() {
    }

    public PipeResolverMsg(Element root) {
        this.initialize(root);
    }

    private void initialize(Element root) {
        Serializable pipeID;
        if (!TextElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports TextElement");
        }
        TextElement doc = (TextElement)root;
        String docName = doc.getName();
        if (!docName.equals(PipeResolverMsg.getMessageType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + docName);
        }
        Enumeration each = doc.getChildren();
        while (each.hasMoreElements()) {
            TextElement elem = (TextElement)each.nextElement();
            if (elem.getName().equals(MsgTypeTag)) {
                String msgtype = elem.getTextValue();
                if (msgtype.equals(QueryMsgType)) {
                    this.setMsgType(PipeResolverMessage.MessageType.QUERY);
                    continue;
                }
                if (msgtype.equals(AnswerMsgType)) {
                    this.setMsgType(PipeResolverMessage.MessageType.ANSWER);
                    continue;
                }
                throw new IllegalArgumentException("Unexpected Message Type in parsing.");
            }
            if (elem.getName().equals(PipeIdTag)) {
                try {
                    pipeID = new URI(elem.getTextValue());
                    this.setPipeID(IDFactory.fromURI((URI)pipeID));
                    continue;
                }
                catch (URISyntaxException badID) {
                    throw new IllegalArgumentException("Bad pipe ID in message");
                }
            }
            if (elem.getName().equals(PipeTypeTag)) {
                this.setPipeType(elem.getTextValue());
                continue;
            }
            if (elem.getName().equals(PeerIdTag)) {
                try {
                    URI peerID = new URI(elem.getTextValue());
                    this.addPeerID(IDFactory.fromURI(peerID));
                    continue;
                }
                catch (URISyntaxException badID) {
                    throw new IllegalArgumentException("Bad peer ID in message");
                }
            }
            if (elem.getName().equals(FoundTag)) {
                this.setFound(Boolean.valueOf(elem.getTextValue()));
                continue;
            }
            if (!elem.getName().equals(PeerAdvTag)) continue;
            String peerAdv = elem.getTextValue();
            try {
                this.setInputPeerAdv((PeerAdvertisement)AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, new StringReader(peerAdv)));
            }
            catch (IOException caught) {
                if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Malformed peer adv in message", caught);
                }
                throw new IllegalArgumentException("Malformed peer adv in message : " + caught.getMessage());
            }
        }
        PipeResolverMessage.MessageType msgType = this.getMsgType();
        if (null == msgType) {
            throw new IllegalArgumentException("Message type was never set!");
        }
        pipeID = this.getPipeID();
        if (null == pipeID || ID.nullID.equals(pipeID) || !(pipeID instanceof PipeID)) {
            throw new IllegalArgumentException("Input Pipe ID not set or invalid");
        }
        if (null == this.getPipeType()) {
            throw new IllegalArgumentException("Pipe type was never set!");
        }
        if (PipeResolverMessage.MessageType.ANSWER.equals((Object)msgType) && this.getPeerIDs().isEmpty()) {
            throw new IllegalArgumentException("An answer without responses is invalid");
        }
    }

    public Document getDocument(MimeMediaType encodeAs) {
        Object element2;
        PipeResolverMessage.MessageType msgType;
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, PipeResolverMsg.getMessageType());
        if (doc instanceof Attributable) {
            ((Attributable)((Object)doc)).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        if (null == (msgType = this.getMsgType())) {
            throw new IllegalStateException("Message type was never set!");
        }
        ID pipeID = this.getPipeID();
        if (null == pipeID || ID.nullID.equals(pipeID) || !(pipeID instanceof PipeID)) {
            throw new IllegalStateException("Pipe ID not set or invalid.");
        }
        String pipeType = this.getPipeType();
        if (null == pipeType || 0 == pipeType.trim().length()) {
            throw new IllegalStateException("Pipe type was never set or is invalid.");
        }
        if (PipeResolverMessage.MessageType.QUERY.equals((Object)msgType)) {
            element2 = doc.createElement(MsgTypeTag, QueryMsgType);
        } else if (PipeResolverMessage.MessageType.ANSWER.equals((Object)msgType)) {
            element2 = doc.createElement(MsgTypeTag, AnswerMsgType);
        } else {
            throw new IllegalStateException("Unknown message type :" + msgType.toString());
        }
        doc.appendChild(element2);
        element2 = doc.createElement(PipeIdTag, pipeID.toString());
        doc.appendChild(element2);
        if (pipeType != null && 0 != pipeType.length()) {
            element2 = doc.createElement(PipeTypeTag, pipeType);
            doc.appendChild(element2);
        }
        Set<ID> peers = this.getPeerIDs();
        if (PipeResolverMessage.MessageType.ANSWER.equals((Object)msgType) && peers.isEmpty()) {
            throw new IllegalStateException("An ANSWER message must contain at least one peer as part of the response.");
        }
        Iterator<ID> i$ = peers.iterator();
        while (i$.hasNext()) {
            ID peer;
            ID aPeer = peer = i$.next();
            element2 = doc.createElement(PeerIdTag, aPeer.toString());
            doc.appendChild(element2);
        }
        if (!PipeResolverMessage.MessageType.QUERY.equals((Object)msgType)) {
            if (PipeResolverMessage.MessageType.ANSWER.equals((Object)msgType)) {
                element2 = doc.createElement(FoundTag, (this.isFound() ? Boolean.TRUE : Boolean.FALSE).toString());
                doc.appendChild(element2);
                PeerAdvertisement peerAdv = this.getInputPeerAdv();
                if (peerAdv != null) {
                    if (!peers.contains(peerAdv.getPeerID())) {
                        throw new IllegalStateException("Provided Peer Advertisement does not refer to one of the peers in the response list.");
                    }
                    StructuredTextDocument asDoc = (StructuredTextDocument)peerAdv.getDocument(MimeMediaType.XMLUTF8);
                    element2 = doc.createElement(PeerAdvTag, asDoc.toString());
                    doc.appendChild(element2);
                }
            } else {
                throw new IllegalStateException("Unknown message type :" + msgType.toString());
            }
        }
        return doc;
    }
}

