/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous.rendezvousMeter;

import net.jxta.impl.rendezvous.rendezvousMeter.RendezvousConnectionMetric;
import net.jxta.peer.PeerID;

public class RendezvousConnectionMeter {
    private PeerID peerID;
    private RendezvousConnectionMetric cumulativeMetrics;
    private RendezvousConnectionMetric deltaMetrics;
    private long transitionTime = 0L;
    private long lastLeaseRenewalTime = 0L;

    public RendezvousConnectionMeter(PeerID peerID) {
        this.peerID = peerID;
        this.cumulativeMetrics = new RendezvousConnectionMetric(peerID);
    }

    public RendezvousConnectionMetric getCumulativeMetrics() {
        return this.cumulativeMetrics;
    }

    public PeerID getPeerID() {
        return this.peerID;
    }

    public String getState() {
        return this.cumulativeMetrics.getState();
    }

    public synchronized RendezvousConnectionMetric collectMetrics() {
        RendezvousConnectionMetric prevDelta = this.deltaMetrics;
        this.deltaMetrics = null;
        return prevDelta;
    }

    private void createDeltaMetric() {
        this.deltaMetrics = new RendezvousConnectionMetric(this.cumulativeMetrics);
    }

    public String toString() {
        return "RendezvousConnectionMeter(" + this.peerID + ")";
    }

    public void beginConnection() {
        this.transitionTime = System.currentTimeMillis();
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.beginConnection(this.transitionTime);
        this.cumulativeMetrics.beginConnection(this.transitionTime);
    }

    public void connectionEstablished(long lease) {
        long now = System.currentTimeMillis();
        long timeToConnect = now - this.transitionTime;
        this.transitionTime = now;
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.connectionEstablished(this.transitionTime, timeToConnect, lease);
        this.cumulativeMetrics.connectionEstablished(this.transitionTime, timeToConnect, lease);
    }

    public void leaseRenewed(long lease) {
        this.lastLeaseRenewalTime = System.currentTimeMillis();
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.leaseRenewed(this.lastLeaseRenewalTime, lease);
        this.cumulativeMetrics.leaseRenewed(this.lastLeaseRenewalTime, lease);
    }

    public void connectionRefused() {
        this.transitionTime = System.currentTimeMillis();
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.connectionRefused(this.transitionTime);
        this.cumulativeMetrics.connectionRefused(this.transitionTime);
    }

    public void connectionDisconnected() {
        this.transitionTime = System.currentTimeMillis();
        if (this.deltaMetrics == null) {
            this.createDeltaMetric();
        }
        this.deltaMetrics.connectionDisconnected(this.transitionTime);
        this.cumulativeMetrics.connectionDisconnected(this.transitionTime);
    }
}

