/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import net.jxta.document.Element;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.id.ID;
import net.jxta.platform.ModuleSpecID;

public abstract class ModuleImplAdvertisement
extends ExtendableAdvertisement
implements Cloneable {
    private ModuleSpecID msid = null;
    private StructuredDocument description = null;
    private StructuredDocument compat = null;
    private String code = null;
    private String uri = null;
    private String provider = null;
    private StructuredDocument param = null;

    public static String getAdvertisementType() {
        return "jxta:MIA";
    }

    public final String getBaseAdvType() {
        return ModuleImplAdvertisement.getAdvertisementType();
    }

    public ModuleImplAdvertisement clone() {
        try {
            ModuleImplAdvertisement clone = (ModuleImplAdvertisement)super.clone();
            clone.setModuleSpecID(this.getModuleSpecID());
            clone.setDesc(this.getDescPriv());
            clone.setCompat(this.getCompatPriv());
            clone.setCode(this.getCode());
            clone.setUri(this.getUri());
            clone.setProvider(this.getProvider());
            clone.setParam(this.getParamPriv());
            return clone;
        }
        catch (CloneNotSupportedException impossible) {
            throw new Error("Object.clone() threw CloneNotSupportedException", impossible);
        }
    }

    public ID getID() {
        return null;
    }

    public ModuleSpecID getModuleSpecID() {
        return this.msid;
    }

    public void setModuleSpecID(ModuleSpecID msid) {
        this.msid = msid;
    }

    public String getDescription() {
        if (null != this.description) {
            return (String)this.description.getValue();
        }
        return null;
    }

    public void setDescription(String description) {
        if (null != description) {
            StructuredDocument newdoc = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Desc", description);
            this.setDesc(newdoc);
        } else {
            this.description = null;
        }
    }

    public StructuredDocument getDesc() {
        if (null != this.description) {
            StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(this.description);
            return newDoc;
        }
        return null;
    }

    public StructuredDocument getDescPriv() {
        return this.description;
    }

    public void setDesc(Element desc) {
        this.description = null != desc ? StructuredDocumentUtils.copyAsDocument(desc) : null;
    }

    public StructuredDocument getCompat() {
        return this.compat == null ? null : StructuredDocumentUtils.copyAsDocument(this.compat);
    }

    protected StructuredDocument getCompatPriv() {
        return this.compat;
    }

    public void setCompat(Element compat) {
        this.compat = compat == null ? null : StructuredDocumentUtils.copyAsDocument(compat);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public StructuredDocument getParam() {
        return this.param == null ? null : StructuredDocumentUtils.copyAsDocument(this.param);
    }

    protected StructuredDocument getParamPriv() {
        return this.param;
    }

    public void setParam(Element param) {
        this.param = param == null ? null : StructuredDocumentUtils.copyAsDocument(param);
    }
}

