/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.Element;
import net.jxta.document.ExtendableAdvertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.logging.Logging;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PeerAdvertisement
extends ExtendableAdvertisement
implements Cloneable {
    private static final Logger LOG = Logger.getLogger(PeerAdvertisement.class.getName());
    private PeerID pid = null;
    private PeerGroupID gid = null;
    private String name = null;
    private Element description = null;
    private final Map<ID, StructuredDocument> serviceParams = new HashMap<ID, StructuredDocument>();
    private final transient AtomicInteger modCount = new AtomicInteger(0);

    public int getModCount() {
        return this.modCount.get();
    }

    protected int incModCount() {
        if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            Throwable trace = new Throwable("Stack Trace");
            StackTraceElement[] elements = trace.getStackTrace();
            LOG.finer("Modification #" + (this.getModCount() + 1) + " to PeerAdv@" + Integer.toHexString(System.identityHashCode(this)) + " caused by : " + "\n\t" + elements[1] + "\n\t" + elements[2]);
        }
        return this.modCount.incrementAndGet();
    }

    public static String getAdvertisementType() {
        return "jxta:PA";
    }

    @Override
    public final String getBaseAdvType() {
        return PeerAdvertisement.getAdvertisementType();
    }

    @Override
    public PeerAdvertisement clone() {
        try {
            PeerAdvertisement clone = (PeerAdvertisement)super.clone();
            clone.setPeerID(this.getPeerID());
            clone.setPeerGroupID(this.getPeerGroupID());
            clone.setName(this.getName());
            clone.setDesc(this.getDesc());
            clone.setServiceParams(this.getServiceParams());
            return clone;
        }
        catch (CloneNotSupportedException impossible) {
            throw new Error("Object.clone() threw CloneNotSupportedException", impossible);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.incModCount();
    }

    public PeerID getPeerID() {
        return this.pid;
    }

    public void setPeerID(PeerID pid) {
        this.pid = pid;
        this.incModCount();
    }

    public PeerGroupID getPeerGroupID() {
        return this.gid;
    }

    public void setPeerGroupID(PeerGroupID gid) {
        this.gid = gid;
        this.incModCount();
    }

    @Override
    public ID getID() {
        if (this.gid == null || this.pid == null) {
            return null;
        }
        try {
            String hashValue = PeerAdvertisement.getAdvertisementType() + this.gid.getUniqueValue().toString() + this.pid.getUniqueValue().toString();
            byte[] seed = hashValue.getBytes("UTF-8");
            return IDFactory.newCodatID(this.gid, seed, new ByteArrayInputStream(seed));
        }
        catch (Exception failed) {
            return null;
        }
    }

    public String getDescription() {
        if (null != this.description) {
            return (String)this.description.getValue();
        }
        return null;
    }

    public void setDescription(String description) {
        if (null != description) {
            StructuredDocument newdoc = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Desc", description);
            this.setDesc(newdoc);
        } else {
            this.description = null;
        }
        this.incModCount();
    }

    public StructuredDocument getDesc() {
        if (null != this.description) {
            StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(this.description);
            return newDoc;
        }
        return null;
    }

    public void setDesc(Element desc) {
        this.description = null != desc ? StructuredDocumentUtils.copyAsDocument(desc) : null;
        this.incModCount();
    }

    public void setServiceParams(Hashtable<ID, ? extends Element> params) {
        this.serviceParams.clear();
        if (params == null) {
            return;
        }
        for (Map.Entry<ID, ? extends Element> anEntry : params.entrySet()) {
            Element e = anEntry.getValue();
            StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(e);
            this.serviceParams.put(anEntry.getKey(), newDoc);
        }
        this.incModCount();
    }

    public Hashtable<ID, StructuredDocument> getServiceParams() {
        Hashtable<ID, StructuredDocument> copy = new Hashtable<ID, StructuredDocument>();
        for (Map.Entry<ID, StructuredDocument> anEntry : this.serviceParams.entrySet()) {
            Element e = anEntry.getValue();
            StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(e);
            copy.put(anEntry.getKey(), newDoc);
        }
        return copy;
    }

    public void putServiceParam(ID key, Element param) {
        if (param == null) {
            this.serviceParams.remove(key);
            this.incModCount();
            return;
        }
        StructuredDocument newDoc = StructuredDocumentUtils.copyAsDocument(param);
        this.serviceParams.put(key, newDoc);
        this.incModCount();
    }

    public StructuredDocument getServiceParam(ID key) {
        StructuredDocument param = this.serviceParams.get(key);
        if (param == null) {
            return null;
        }
        return StructuredDocumentUtils.copyAsDocument(param);
    }

    public StructuredDocument removeServiceParam(ID key) {
        Element param = this.serviceParams.remove(key);
        if (param == null) {
            return null;
        }
        this.incModCount();
        return StructuredDocumentUtils.copyAsDocument(param);
    }
}

