/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.socket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.credential.Credential;
import net.jxta.credential.CredentialValidator;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.socket.JxtaSocket;
import net.jxta.socket.JxtaSocketAddress;

public class JxtaServerSocket
extends ServerSocket
implements PipeMsgListener {
    private static final Logger LOG = Logger.getLogger(JxtaServerSocket.class.getName());
    protected static final String MSG_ELEMENT_NAMESPACE = "JXTASOC";
    protected static final String credTag = "Cred";
    protected static final String reqPipeTag = "reqPipe";
    protected static final String remPeerTag = "remPeer";
    protected static final String remPipeTag = "remPipe";
    protected static final String dataTag = "data";
    protected static final String closeTag = "close";
    protected static final String closeReqValue = "close";
    protected static final String closeAckValue = "closeACK";
    protected static final String streamTag = "stream";
    private static final int DEFAULT_BACKLOG = 50;
    private static final long DEFAULT_TIMEOUT = 60000L;
    protected static final Message QUEUE_END_MESSAGE = new Message();
    protected PeerGroup group;
    protected PipeAdvertisement pipeAdv;
    protected InputPipe serverPipe;
    protected Credential localCredential = null;
    protected int backlog = 50;
    protected long timeout = 60000L;
    protected BlockingQueue<Message> queue = null;
    protected volatile boolean bound = false;
    protected volatile boolean closed = false;
    private CredentialValidator credValidator = null;

    public JxtaServerSocket() throws IOException {
    }

    public JxtaServerSocket(SocketAddress address) throws IOException {
        this(address, 50);
    }

    public JxtaServerSocket(PeerGroup group, PipeAdvertisement pipeAdv) throws IOException {
        this(group, pipeAdv, 50);
    }

    public JxtaServerSocket(SocketAddress address, int backlog) throws IOException {
        this(address, backlog, 60000);
    }

    public JxtaServerSocket(PeerGroup group, PipeAdvertisement pipeAdv, int backlog) throws IOException {
        this(group, pipeAdv, backlog, 60000);
    }

    public JxtaServerSocket(SocketAddress address, int backlog, int timeout) throws IOException {
        this.setSoTimeout(timeout);
        this.bind(address, backlog);
    }

    public JxtaServerSocket(PeerGroup group, PipeAdvertisement pipeAdv, int backlog, int timeout) throws IOException {
        this(group, pipeAdv, backlog, timeout, null);
    }

    public JxtaServerSocket(PeerGroup group, PipeAdvertisement pipeAdv, int backlog, int timeout, CredentialValidator credValidator) throws IOException {
        this.setSoTimeout(timeout);
        this.credValidator = credValidator;
        this.bind(group, pipeAdv, backlog);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed && Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("JxtaServerSocket is being finalized without being previously closed. This is likely an application level bug.");
        }
        this.close();
    }

    public Socket accept() throws IOException {
        if (!this.isBound()) {
            throw new SocketException("Socket is not bound yet");
        }
        try {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Waiting for a connection");
            }
            while (true) {
                if (this.isClosed()) {
                    throw new SocketException("Socket is closed");
                }
                Message msg = this.queue.poll(this.timeout, TimeUnit.MILLISECONDS);
                if (this.isClosed()) {
                    throw new SocketException("Socket is closed");
                }
                if (msg == null) {
                    throw new SocketTimeoutException("Timeout reached");
                }
                if (QUEUE_END_MESSAGE == msg) {
                    throw new SocketException("Socket is closed.");
                }
                JxtaSocket socket = this.processMessage(msg);
                if (socket != null) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("New socket connection " + socket);
                    }
                    return socket;
                }
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("No connection.");
            }
        }
        catch (InterruptedException ie) {
            SocketException interrupted = new SocketException("interrupted");
            interrupted.initCause(ie);
            throw interrupted;
        }
    }

    public void bind(PeerGroup group, PipeAdvertisement pipeAdv) throws IOException {
        this.bind(group, pipeAdv, 50);
    }

    public void bind(PeerGroup group, PipeAdvertisement pipeadv, int backlog) throws IOException {
        if ("JxtaPropagate".equals(pipeadv.getType())) {
            throw new IOException("Propagate pipe advertisements are not supported");
        }
        if (backlog <= 0) {
            throw new IllegalArgumentException("backlog must be > 0");
        }
        this.backlog = backlog;
        this.queue = new ArrayBlockingQueue<Message>(backlog);
        this.group = group;
        this.pipeAdv = pipeadv;
        PipeService pipeSvc = group.getPipeService();
        this.serverPipe = pipeSvc.createInputPipe(pipeadv, this);
        this.setBound(true);
    }

    public void bind(SocketAddress endpoint) throws IOException {
        this.bind(endpoint, this.backlog);
    }

    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        PeerGroup pg;
        JxtaSocketAddress socketAddress;
        if (endpoint instanceof JxtaSocketAddress) {
            socketAddress = (JxtaSocketAddress)endpoint;
            pg = PeerGroup.globalRegistry.lookupInstance(socketAddress.getPeerGroupId());
            if (pg == null) {
                throw new IOException("Can't connect socket in PeerGroup with id " + socketAddress.getPeerGroupId() + ". No running instance of the group is registered.");
            }
        } else {
            throw new IllegalArgumentException("Unsupported subclass of SocketAddress; use JxtaSocketAddress instead.");
        }
        this.bind(pg.getWeakInterface(), socketAddress.getPipeAdv(), backlog);
        pg.unref();
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.isBound()) {
            this.serverPipe.close();
            this.setBound(false);
        }
        this.queue.clear();
        while (true) {
            try {
                this.queue.put(QUEUE_END_MESSAGE);
            }
            catch (InterruptedException woken) {
                Thread.interrupted();
                continue;
            }
            break;
        }
        if (Logging.SHOW_INFO && LOG.isLoggable(Level.INFO)) {
            LOG.info("Closed : " + this);
        }
    }

    public SocketAddress getLocalSocketAddress() {
        return new JxtaSocketAddress(this.getGroup(), this.getPipeAdv());
    }

    public int getSoTimeout() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.timeout > Integer.MAX_VALUE) {
            return 0;
        }
        return (int)this.timeout;
    }

    public void setSoTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout must be >= 0");
        }
        this.timeout = 0 == timeout ? Long.MAX_VALUE : (long)timeout;
    }

    public boolean isBound() {
        return this.bound;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private synchronized void setBound(boolean boundState) {
        this.bound = boundState;
    }

    public PeerGroup getGroup() {
        return this.group;
    }

    public PipeAdvertisement getPipeAdv() {
        return this.pipeAdv;
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        boolean pushed;
        block4: {
            Message message = event.getMessage();
            if (message == null) {
                return;
            }
            pushed = false;
            try {
                pushed = this.queue.offer(message, this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException woken) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block4;
                LOG.log(Level.FINE, "Interrupted", woken);
            }
        }
        if (!pushed && Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("backlog queue full, connect request dropped");
        }
    }

    private JxtaSocket processMessage(Message msg) {
        block15: {
            PipeAdvertisement remoteEphemeralPipeAdv = null;
            PeerAdvertisement remotePeerAdv = null;
            Credential credential = null;
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Processing a connection message : " + msg);
            }
            try {
                MessageElement el = msg.getMessageElement(MSG_ELEMENT_NAMESPACE, reqPipeTag);
                if (el != null) {
                    XMLDocument pipeAdvDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(el);
                    remoteEphemeralPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(pipeAdvDoc);
                }
                if ((el = msg.getMessageElement(MSG_ELEMENT_NAMESPACE, remPeerTag)) != null) {
                    XMLDocument peerAdvDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(el);
                    remotePeerAdv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(peerAdvDoc);
                }
                if ((el = msg.getMessageElement(MSG_ELEMENT_NAMESPACE, credTag)) != null) {
                    try {
                        XMLDocument credDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(el);
                        credential = this.group.getMembershipService().makeCredential(credDoc);
                        if (!this.checkCred(credential)) {
                            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                                LOG.log(Level.WARNING, "Invalid credential");
                            }
                            return null;
                        }
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
                boolean isReliable = false;
                el = msg.getMessageElement(MSG_ELEMENT_NAMESPACE, streamTag);
                if (el != null) {
                    isReliable = Boolean.valueOf(el.toString());
                }
                if (null != remoteEphemeralPipeAdv && null != remotePeerAdv) {
                    return this.createEphemeralSocket(this.group, this.pipeAdv, remoteEphemeralPipeAdv, remotePeerAdv, this.localCredential, credential, isReliable);
                }
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Connection message did not contain valid connection information.");
                }
                return null;
            }
            catch (IOException e) {
                if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "IOException occured", e);
                }
            }
            catch (RuntimeException e) {
                if (!Logging.SHOW_WARNING || !LOG.isLoggable(Level.WARNING)) break block15;
                LOG.log(Level.WARNING, "Exception occured", e);
            }
        }
        return null;
    }

    private boolean checkCred(Credential cred) {
        return this.credValidator == null || this.credValidator.checkCred(cred);
    }

    protected JxtaSocket createEphemeralSocket(PeerGroup group, PipeAdvertisement pipeAdv, PipeAdvertisement remoteEphemeralPipeAdv, PeerAdvertisement remotePeerAdv, Credential localCredential, Credential credential, boolean isReliable) throws IOException {
        return new JxtaSocket(group, pipeAdv, remoteEphemeralPipeAdv, remotePeerAdv, localCredential, credential, isReliable);
    }

    public void setCredential(Credential localCredential) {
        this.localCredential = localCredential;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getName());
        result.append('@');
        result.append(System.identityHashCode(this));
        result.append('[');
        result.append(this.pipeAdv.getPipeID());
        result.append(']');
        result.append(this.isClosed() ? " CLOSED :" : " OPEN :");
        result.append(this.isBound() ? " BOUND " : " UNBOUND ");
        return result.toString();
    }
}

