/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class CountingWriter
extends FilterWriter {
    private transient boolean alreadycounting = false;
    private long charsWritten = 0L;

    public CountingWriter(Writer out) {
        super(out);
    }

    public String toString() {
        if (null == this.out) {
            return "closed/" + super.toString();
        }
        return this.out.toString() + "/" + super.toString();
    }

    public synchronized void write(int b) throws IOException {
        boolean wascounting = this.alreadycounting;
        this.alreadycounting = true;
        super.write(b);
        this.alreadycounting = wascounting;
        if (!this.alreadycounting) {
            ++this.charsWritten;
        }
    }

    public synchronized void write(char[] b, int off, int len) throws IOException {
        boolean wascounting = this.alreadycounting;
        this.alreadycounting = true;
        super.write(b, off, len);
        this.alreadycounting = wascounting;
        if (!this.alreadycounting) {
            this.charsWritten += (long)len;
        }
    }

    public synchronized long getCharsWritten() {
        return this.charsWritten;
    }
}

