/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util;

import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.XMLDocument;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.endpoint.TextDocumentMessageElement;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.tcp.TcpMessenger;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.util.JxtaBiDiPipe;

public class JxtaServerPipe
implements PipeMsgListener {
    private static final Logger LOG = Logger.getLogger(JxtaServerPipe.class.getName());
    protected static final String nameSpace = "JXTABIP";
    protected static final String credTag = "Cred";
    protected static final String reqPipeTag = "reqPipe";
    protected static final String remPeerTag = "remPeer";
    protected static final String remPipeTag = "remPipe";
    protected static final String closeTag = "close";
    protected static final String reliableTag = "reliable";
    protected static final String directSupportedTag = "direct";
    private PeerGroup group;
    private InputPipe serverPipe;
    private PipeAdvertisement pipeadv;
    private int backlog = 50;
    private long timeout = 30000L;
    private final Object closeLock = new Object();
    protected BlockingQueue<JxtaBiDiPipe> connectionQueue = null;
    private boolean bound = false;
    private boolean closed = false;
    protected StructuredDocument myCredentialDoc = null;
    private final ExecutorService executor;

    public JxtaServerPipe(PeerGroup group, PipeAdvertisement pipeadv) throws IOException {
        this(group, pipeadv, 50);
    }

    public JxtaServerPipe(PeerGroup group, PipeAdvertisement pipeadv, int backlog, int timeout) throws IOException {
        this(group, pipeadv, backlog);
        this.timeout = timeout;
    }

    public JxtaServerPipe(PeerGroup group, PipeAdvertisement pipeadv, int backlog) throws IOException {
        this.group = group;
        this.executor = Executors.newFixedThreadPool(3);
        this.pipeadv = pipeadv;
        this.backlog = backlog;
        this.connectionQueue = new ArrayBlockingQueue<JxtaBiDiPipe>(backlog);
        PipeService pipeSvc = group.getPipeService();
        this.serverPipe = pipeSvc.createInputPipe(pipeadv, this);
        this.setBound();
    }

    public void bind(PeerGroup group, PipeAdvertisement pipeadv) throws IOException {
        this.bind(group, pipeadv, this.backlog);
    }

    public void bind(PeerGroup group, PipeAdvertisement pipeadv, int backlog) throws IOException {
        this.backlog = backlog;
        this.connectionQueue = new ArrayBlockingQueue<JxtaBiDiPipe>(backlog);
        this.group = group;
        this.pipeadv = pipeadv;
        PipeService pipeSvc = group.getPipeService();
        this.serverPipe = pipeSvc.createInputPipe(pipeadv, this);
        this.setBound();
    }

    public JxtaBiDiPipe accept() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("JxtaServerPipe is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("JxtaServerPipe is not bound yet");
        }
        try {
            JxtaBiDiPipe bidi = this.connectionQueue.poll(this.timeout, TimeUnit.MILLISECONDS);
            if (bidi == null) {
                throw new SocketTimeoutException("Timeout reached");
            }
            return bidi;
        }
        catch (InterruptedException ie) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Interrupted", ie);
            }
            throw new SocketException("interrupted");
        }
    }

    public PeerGroup getGroup() {
        return this.group;
    }

    public PipeAdvertisement getPipeAdv() {
        return this.pipeadv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            if (this.bound) {
                this.serverPipe.close();
                this.connectionQueue.clear();
                this.executor.shutdownNow();
                this.bound = false;
            }
            this.closed = true;
        }
    }

    void setBound() {
        this.bound = true;
    }

    public synchronized int getPipeTimeout() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Server Pipe is closed");
        }
        if (this.timeout > Integer.MAX_VALUE) {
            return 0;
        }
        return (int)this.timeout;
    }

    public synchronized void setPipeTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Server Pipe is closed");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("Negative timeout values are not allowed.");
        }
        this.timeout = 0 == timeout ? Long.MAX_VALUE : (long)timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.closed;
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        Message message = event.getMessage();
        if (message == null) {
            return;
        }
        ConnectionProcessor processor = new ConnectionProcessor(message);
        this.executor.execute(processor);
    }

    private JxtaBiDiPipe processMessage(Message msg) {
        block15: {
            PipeAdvertisement outputPipeAdv = null;
            PeerAdvertisement peerAdv = null;
            StructuredDocument credDoc = null;
            try {
                Messenger msgr;
                XMLDocument asDoc;
                MessageElement el = msg.getMessageElement(nameSpace, credTag);
                if (el != null) {
                    credDoc = StructuredDocumentFactory.newStructuredDocument(el);
                }
                if ((el = msg.getMessageElement(nameSpace, reqPipeTag)) != null) {
                    asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(el);
                    outputPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(asDoc);
                }
                if ((el = msg.getMessageElement(nameSpace, remPeerTag)) != null) {
                    asDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(el);
                    peerAdv = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(asDoc);
                }
                el = msg.getMessageElement(nameSpace, reliableTag);
                boolean isReliable = false;
                if (el != null) {
                    isReliable = Boolean.valueOf(el.toString());
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Connection request [isReliable] :" + isReliable);
                    }
                }
                el = msg.getMessageElement(nameSpace, directSupportedTag);
                boolean directSupported = false;
                if (el != null) {
                    directSupported = Boolean.valueOf(el.toString());
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Connection request [directSupported] :" + directSupported);
                    }
                }
                boolean direct = false;
                if (directSupported) {
                    msgr = JxtaBiDiPipe.getDirectMessenger(this.group, outputPipeAdv, peerAdv);
                    if (msgr == null) {
                        msgr = JxtaBiDiPipe.lightweightOutputPipe(this.group, outputPipeAdv, peerAdv);
                    } else {
                        direct = true;
                    }
                } else {
                    msgr = JxtaBiDiPipe.lightweightOutputPipe(this.group, outputPipeAdv, peerAdv);
                }
                if (msgr != null) {
                    if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Reliability set to :" + isReliable);
                    }
                    PipeAdvertisement newpipe = JxtaServerPipe.newInputPipe(this.group, outputPipeAdv);
                    JxtaBiDiPipe pipe = new JxtaBiDiPipe(this.group, msgr, newpipe, credDoc, isReliable, direct);
                    pipe.setRemotePeerAdvertisement(peerAdv);
                    pipe.setRemotePipeAdvertisement(outputPipeAdv);
                    this.sendResponseMessage(this.group, msgr, newpipe);
                    return pipe;
                }
            }
            catch (IOException e) {
                if (!Logging.SHOW_FINE || !LOG.isLoggable(Level.FINE)) break block15;
                LOG.log(Level.FINE, "IOException occured", e);
            }
        }
        return null;
    }

    protected void sendResponseMessage(PeerGroup group, Messenger msgr, PipeAdvertisement pipeAd) throws IOException {
        Message msg = new Message();
        PeerAdvertisement peerAdv = group.getPeerAdvertisement();
        if (this.myCredentialDoc == null) {
            this.myCredentialDoc = JxtaBiDiPipe.getCredDoc(group);
        }
        if (this.myCredentialDoc != null) {
            msg.addMessageElement(nameSpace, new TextDocumentMessageElement(credTag, (XMLDocument)this.myCredentialDoc, null));
        }
        msg.addMessageElement(nameSpace, new StringMessageElement(directSupportedTag, Boolean.toString(true), null));
        msg.addMessageElement(nameSpace, new TextDocumentMessageElement(remPipeTag, (XMLDocument)pipeAd.getDocument(MimeMediaType.XMLUTF8), null));
        msg.addMessageElement(nameSpace, new TextDocumentMessageElement(remPeerTag, (XMLDocument)peerAdv.getDocument(MimeMediaType.XMLUTF8), null));
        if (msgr instanceof TcpMessenger) {
            ((TcpMessenger)msgr).sendMessageDirect(msg, null, null, true);
        } else {
            msgr.sendMessage(msg);
        }
    }

    protected static PipeAdvertisement newInputPipe(PeerGroup group, PipeAdvertisement pipeadv) {
        PipeAdvertisement adv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement(PipeAdvertisement.getAdvertisementType());
        adv.setPipeID(IDFactory.newPipeID(group.getPeerGroupID()));
        adv.setName(pipeadv.getName());
        adv.setType(pipeadv.getType());
        return adv;
    }

    public StructuredDocument getCredentialDoc() {
        return this.myCredentialDoc;
    }

    public void setCredentialDoc(StructuredDocument doc) {
        this.myCredentialDoc = doc;
    }

    protected synchronized void finalize() throws Throwable {
        if (!this.closed && Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("JxtaServerPipe is being finalized without being previously closed. This is likely a user's bug.");
        }
        this.close();
        super.finalize();
    }

    private class ConnectionProcessor
    implements Runnable {
        private Message message;

        ConnectionProcessor(Message message) {
            this.message = message;
        }

        public void run() {
            JxtaBiDiPipe bidi = JxtaServerPipe.this.processMessage(this.message);
            if (bidi != null) {
                try {
                    JxtaServerPipe.this.connectionQueue.offer(bidi, JxtaServerPipe.this.timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        }
    }
}

