/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.util.documentSerializable;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLDocument;
import net.jxta.exception.JxtaException;
import net.jxta.util.documentSerializable.DocumentSerializable;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class DocumentSerializableUtilities {
    public static XMLDocument createStructuredXmlDocument(String docType, DocumentSerializable documentSerializable) throws DocumentSerializationException {
        XMLDocument xmlDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, docType);
        documentSerializable.serializeTo(xmlDoc);
        return xmlDoc;
    }

    public static void copyChildren(Element toElement, Element fromElement) {
        StructuredDocument intoDoc = toElement.getRoot();
        StructuredDocumentUtils.copyChildren(intoDoc, toElement, fromElement);
    }

    public static void addDocumentSerializable(Element element2, String tagName, DocumentSerializable documentSerializable) throws DocumentSerializationException {
        StructuredDocument structuredDocument = element2.getRoot();
        Object childElement = structuredDocument.createElement(tagName);
        element2.appendChild(childElement);
        documentSerializable.serializeTo((Element)childElement);
    }

    public static DocumentSerializable getDocumentSerializable(Element element2, Class clazz) throws DocumentSerializationException {
        try {
            return DocumentSerializableUtilities.getDocumentSerializable(element2, (DocumentSerializable)clazz.newInstance());
        }
        catch (DocumentSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocumentSerializationException("Class must have a public no-arg constructor", e);
        }
    }

    public static DocumentSerializable getDocumentSerializable(Element element2, DocumentSerializable documentSerializable) throws DocumentSerializationException {
        documentSerializable.initializeFrom(element2);
        return documentSerializable;
    }

    public static DocumentSerializable getDocumentSerializable(Element element2, String tagName, Class clazz) throws DocumentSerializationException {
        Element childElement = DocumentSerializableUtilities.getChildElement(element2, tagName);
        if (childElement != null) {
            return DocumentSerializableUtilities.getDocumentSerializable(childElement, clazz);
        }
        return null;
    }

    public static DocumentSerializable copyDocumentSerializable(DocumentSerializable documentSerializable) throws DocumentSerializationException {
        XMLDocument structuredDocument = DocumentSerializableUtilities.createStructuredXmlDocument("temp", documentSerializable);
        return DocumentSerializableUtilities.getDocumentSerializable((Element)structuredDocument, documentSerializable.getClass());
    }

    public static Element createChildElement(Element element2, String tagName) {
        StructuredDocument structuredDocument = element2.getRoot();
        Object childElement = structuredDocument.createElement(tagName);
        element2.appendChild(childElement);
        return childElement;
    }

    public static Element getChildElement(Element element2, String tagName) {
        Enumeration e = element2.getChildren(tagName);
        if (e.hasMoreElements()) {
            return (Element)e.nextElement();
        }
        return null;
    }

    public static void addInt(Element element2, String tagName, int value) {
        StructuredDocument structuredDocument = element2.getRoot();
        Object childElement = structuredDocument.createElement(tagName, Integer.toString(value));
        element2.appendChild(childElement);
    }

    public static int getInt(Element element2) {
        return Integer.parseInt((String)element2.getValue());
    }

    public static int getInt(Element element2, String tagName, int defaultValue) {
        Element childElement = DocumentSerializableUtilities.getChildElement(element2, tagName);
        if (childElement != null) {
            return DocumentSerializableUtilities.getInt(childElement);
        }
        return defaultValue;
    }

    public static void addLong(Element element2, String tagName, long value) {
        StructuredDocument structuredDocument = element2.getRoot();
        Object childElement = structuredDocument.createElement(tagName, Long.toString(value));
        element2.appendChild(childElement);
    }

    public static long getLong(Element element2) {
        return Long.parseLong((String)element2.getValue());
    }

    public static long getLong(Element element2, String tagName, long defaultValue) {
        Element childElement = DocumentSerializableUtilities.getChildElement(element2, tagName);
        if (childElement != null) {
            return DocumentSerializableUtilities.getLong(childElement);
        }
        return defaultValue;
    }

    public static void addDouble(Element element2, String tagName, double value) {
        StructuredDocument structuredDocument = element2.getRoot();
        Object childElement = structuredDocument.createElement(tagName, Double.toString(value));
        element2.appendChild(childElement);
    }

    public static double getDouble(Element element2) {
        return Double.parseDouble((String)element2.getValue());
    }

    public static double getDouble(Element element2, String tagName, double defaultValue) {
        Element childElement = DocumentSerializableUtilities.getChildElement(element2, tagName);
        if (childElement != null) {
            return DocumentSerializableUtilities.getDouble(childElement);
        }
        return defaultValue;
    }

    public static void addBoolean(Element element2, String tagName, boolean value) {
        StructuredDocument structuredDocument = element2.getRoot();
        Object childElement = structuredDocument.createElement(tagName, value ? "true" : "false");
        element2.appendChild(childElement);
    }

    public static boolean getBoolean(Element element2) {
        return "true".equals((String)element2.getValue());
    }

    public static boolean getBoolean(Element element2, String tagName, boolean defaultValue) {
        Element childElement = DocumentSerializableUtilities.getChildElement(element2, tagName);
        if (childElement != null) {
            return DocumentSerializableUtilities.getBoolean(childElement);
        }
        return defaultValue;
    }

    public static void addString(Element element2, String tagName, String value) {
        StructuredDocument structuredDocument = element2.getRoot();
        Object childElement = structuredDocument.createElement(tagName, value);
        element2.appendChild(childElement);
    }

    public static String getString(Element element2) {
        return (String)element2.getValue();
    }

    public static String getString(Element element2, String tagName, String defaultValue) {
        Element childElement = DocumentSerializableUtilities.getChildElement(element2, tagName);
        if (childElement != null) {
            return DocumentSerializableUtilities.getString(childElement);
        }
        return defaultValue;
    }

    public static String toXmlString(DocumentSerializable documentSerializable) throws DocumentSerializationException {
        return DocumentSerializableUtilities.toXmlString(documentSerializable, "documentSerializable");
    }

    public static String toXmlString(DocumentSerializable documentSerializable, String rootTagName) throws DocumentSerializationException {
        try {
            StringWriter bout = new StringWriter();
            XMLDocument document = DocumentSerializableUtilities.createStructuredXmlDocument(rootTagName, documentSerializable);
            document.sendToWriter(bout);
            bout.close();
            return bout.toString();
        }
        catch (IOException e) {
            throw new DocumentSerializationException("Error converting to String", e);
        }
    }

    public static void writeAsXmlString(OutputStream out, DocumentSerializable documentSerializable) throws IOException, DocumentSerializationException {
        DocumentSerializableUtilities.writeAsXmlString(out, documentSerializable, "documentSerializable");
    }

    public static void writeAsXmlString(OutputStream out, DocumentSerializable documentSerializable, String rootTagName) throws IOException, DocumentSerializationException {
        XMLDocument document = DocumentSerializableUtilities.createStructuredXmlDocument(rootTagName, documentSerializable);
        document.sendToStream(out);
    }

    public static void printAsXmlString(DocumentSerializable documentSerializable) {
        try {
            if (documentSerializable == null) {
                System.err.println("<null DocumentSerializable>");
            } else {
                DocumentSerializableUtilities.writeAsXmlString(System.err, documentSerializable);
            }
        }
        catch (Exception e) {
            System.err.println("<Error converting DocumentSerializable to XML doc: " + e);
        }
    }

    public static DocumentSerializable getDocumentSerializableFromXml(String buf, Class clazz) throws DocumentSerializationException {
        try {
            XMLDocument xmlDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(buf));
            return DocumentSerializableUtilities.getDocumentSerializable((Element)xmlDoc.getRoot(), clazz);
        }
        catch (IOException readErr) {
            throw new DocumentSerializationException("Unable to read the document", readErr);
        }
        catch (JxtaException e) {
            throw new DocumentSerializationException("Unable to get the document", e);
        }
    }

    public static DocumentSerializable getDocumentSerializableFromXml(byte[] buf, Class clazz) throws DocumentSerializationException {
        return DocumentSerializableUtilities.getDocumentSerializableFromXml(new ByteArrayInputStream(buf), clazz);
    }

    public static DocumentSerializable getDocumentSerializableFromXml(InputStream in, Class clazz) throws DocumentSerializationException {
        try {
            XMLDocument xmlDoc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, in);
            return DocumentSerializableUtilities.getDocumentSerializable((Element)xmlDoc.getRoot(), clazz);
        }
        catch (IOException readErr) {
            throw new DocumentSerializationException("Unable to read the document", readErr);
        }
        catch (JxtaException e) {
            throw new DocumentSerializationException("Unable to get the document", e);
        }
    }
}

