/*
 * $Id:MandelbrotZoom.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot;

/**
 * @author Andrea Medeghini
 */
public class MandelbrotZoom {
	public boolean isDynamic;
	public boolean zoomEnabled;
	public boolean shiftEnabled;
	public boolean rotationEnabled;
	public int zoomDirection;
	public int shiftDirection;
	public int rotationDirection;
	public double lastX;
	public double lastY;
	public double startX;
	public double startY;

	/**
	 * @param isDynamic
	 * @param zoomEnabled
	 * @param shiftEnabled
	 * @param rotationEnabled
	 * @param zoomDirection
	 * @param shiftDirection
	 * @param rotationDirection
	 * @param lastX
	 * @param lastY
	 * @param startX
	 * @param starty
	 */
	public MandelbrotZoom(final boolean isDynamic, final boolean zoomEnabled, final boolean shiftEnabled, final boolean rotationEnabled, final int zoomDirection, final int shiftDirection, final int rotationDirection, final double lastX, final double lastY, final double startX, final double startY) {
		this.isDynamic = isDynamic;
		this.zoomEnabled = zoomEnabled;
		this.shiftEnabled = shiftEnabled;
		this.rotationEnabled = rotationEnabled;
		this.zoomDirection = zoomDirection;
		this.shiftDirection = shiftDirection;
		this.rotationDirection = rotationDirection;
		this.lastX = lastX;
		this.lastY = lastY;
		this.startX = startX;
		this.startY = startY;
	}
}
