/*
 * $Id:UniversalTrueColorConfigXMLImporterRuntime.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot.extensions.fractal.incolouring;

import java.util.List;

import net.sf.jame.core.xml.XMLImportException;
import net.sf.jame.core.xml.XMLImporter;
import net.sf.jame.mandelbrot.color.ColorRendererConfigElement;
import net.sf.jame.mandelbrot.color.ColorRendererConfigElementXMLImporter;
import net.sf.jame.twister.xmlimport.extension.ExtensionConfigXMLImporterExtensionRuntime;

import org.w3c.dom.Element;

/**
 * @author Andrea Medeghini
 */
public class UniversalTrueColorConfigXMLImporterRuntime extends ExtensionConfigXMLImporterExtensionRuntime {
	/**
	 * @see net.sf.jame.twister.xmlimport.extension.ExtensionConfigXMLImporterExtensionRuntime#createXMLImporter()
	 */
	@Override
	public XMLImporter<UniversalTrueColorConfig> createXMLImporter() {
		return new UniversalTrueColorConfigXMLImporter();
	}

	private class UniversalTrueColorConfigXMLImporter extends AbstractIncolouringFormulaConfigXMLImporter<UniversalTrueColorConfig> {
		/**
		 * @see net.sf.jame.mandelbrot.extensions.fractal.incolouring.AbstractIncolouringFormulaConfigXMLImporter#createExtensionConfig()
		 */
		@Override
		protected UniversalTrueColorConfig createExtensionConfig() {
			return new UniversalTrueColorConfig();
		}

		/**
		 * @see net.sf.jame.mandelbrot.extensions.fractal.incolouring.AbstractIncolouringFormulaConfigXMLImporter#getConfigElementClassId()
		 */
		@Override
		protected String getConfigElementClassId() {
			return "UniversalTrueColorConfig";
		}

		/**
		 * @see net.sf.jame.mandelbrot.extensions.fractal.incolouring.AbstractIncolouringFormulaConfigXMLImporter#getPropertiesSize()
		 */
		@Override
		protected int getPropertiesSize() {
			return 1;
		}

		/**
		 * @see net.sf.jame.mandelbrot.extensions.fractal.incolouring.AbstractIncolouringFormulaConfigXMLImporter#importProperties(net.sf.jame.mandelbrot.fractal.incolouring.extension.IncolouringFormulaExtensionConfig, java.util.List)
		 */
		@Override
		protected void importProperties(final UniversalTrueColorConfig config, final List<Element> propertyElements) throws XMLImportException {
			importColorRenderers(config, propertyElements.get(0));
		}

		/**
		 * @param config
		 * @param element
		 * @throws XMLImportException
		 */
		protected void importColorRenderers(final UniversalTrueColorConfig config, final Element element) throws XMLImportException {
			final List<Element> elements = this.getElements(element, ColorRendererConfigElement.CLASS_ID);
			if (elements.size() == 4) {
				config.getColorRendererElement(0).setReference(new ColorRendererConfigElementXMLImporter().importFromElement(elements.get(0)).getReference());
				config.getColorRendererElement(1).setReference(new ColorRendererConfigElementXMLImporter().importFromElement(elements.get(1)).getReference());
				config.getColorRendererElement(2).setReference(new ColorRendererConfigElementXMLImporter().importFromElement(elements.get(2)).getReference());
				config.getColorRendererElement(3).setReference(new ColorRendererConfigElementXMLImporter().importFromElement(elements.get(3)).getReference());
			}
		}
	}
}
