/*
 * $Id:BinaryConfig.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot.extensions.fractal.outcolouring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import net.sf.jame.core.config.ConfigElement;
import net.sf.jame.twister.Color32bit;
import net.sf.jame.twister.common.ColorElement;

/**
 * @author Andrea Medeghini
 */
public class BinaryConfig extends AbstractOutcolouringFormulaConfig {
	private static final long serialVersionUID = 1L;
	private static final Color32bit[] DEFAULT_COLORS = new Color32bit[] { new Color32bit(0xFF000000), new Color32bit(0xFFFFFFFF) };
	private ColorElement[] colorElements;

	/**
	 * 
	 */
	@Override
	protected void createConfigElements() {
		colorElements = new ColorElement[2];
		colorElements[0] = new ColorElement(getDefaultColors()[0]);
		colorElements[1] = new ColorElement(getDefaultColors()[1]);
	}

	/**
	 * @see net.sf.jame.core.extension.ExtensionConfig#getConfigElements()
	 */
	@Override
	public List<ConfigElement> getConfigElements() {
		final List<ConfigElement> elements = new ArrayList<ConfigElement>(1);
		elements.add(colorElements[0]);
		elements.add(colorElements[1]);
		return elements;
	}

	/**
	 * @param colors
	 */
	public void setColors(final Color32bit[] colors) {
		colorElements[0].setValue(colors[0]);
		colorElements[1].setValue(colors[1]);
	}

	/**
	 * @return the colors.
	 */
	public Color32bit[] getColors() {
		return new Color32bit[] { colorElements[0].getValue(), colorElements[1].getValue() };
	}

	/**
	 * @return the default colors.
	 */
	public Color32bit[] getDefaultColors() {
		return BinaryConfig.DEFAULT_COLORS;
	}

	/**
	 * @param index
	 * @return
	 */
	protected ColorElement getColorElement(final int index) {
		return colorElements[index];
	}

	/**
	 * @return
	 */
	@Override
	public BinaryConfig clone() {
		final BinaryConfig config = new BinaryConfig();
		config.setColors(getColors());
		return config;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		final BinaryConfig other = (BinaryConfig) obj;
		if (!Arrays.equals(colorElements, other.colorElements)) {
			return false;
		}
		return true;
	}
}
