/*
 * $Id:MAGNETISM2Runtime.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot.extensions.fractal.rendering;

import java.util.ArrayList;
import java.util.List;

import net.sf.jame.core.math.Complex;
import net.sf.jame.mandelbrot.renderer.RenderedPoint;

/**
 * @author Andrea Medeghini
 */
public class MAGNETISM2Runtime extends AbstractRenderingFormulaRuntime<MAGNETISM2Config> {
	private final Complex ta = new Complex(0, 0);
	private final Complex tb = new Complex(0, 0);
	private final Complex tc = new Complex(0, 0);
	private final Complex td = new Complex(0, 0);
	private final Complex te = new Complex(0, 0);
	private final Complex tf = new Complex(0, 0);
	private final Complex z = new Complex(0, 0);
	private final Complex x = new Complex(0, 0);
	private final Complex w = new Complex(0, 0);
	private final Complex a = new Complex(1d);
	private final Complex b = new Complex(2d);
	private final Complex c = new Complex(3d);

	/**
	 * @see net.sf.jame.mandelbrot.extensions.fractal.rendering.AbstractRenderingFormulaRuntime#isVerticalSymetryAllowed()
	 */
	@Override
	public boolean isVerticalSymetryAllowed() {
		return true;
	}

	/**
	 * @see net.sf.jame.mandelbrot.fractal.rendering.extension.RenderingFormulaExtensionRuntime#renderPoint(net.sf.jame.mandelbrot.renderer.RenderedPoint)
	 */
	@Override
	public int renderPoint(final RenderedPoint cp) {
		cp.time = 0;
		x.r = cp.xr;
		x.i = cp.xi;
		w.r = cp.wr;
		w.i = cp.wi;
		for (int k = 1; k <= iterations; k++) {
			Complex.mul(ta, x, x);
			Complex.mul(tb, ta, x);
			Complex.sub(tc, w, a);
			Complex.sub(td, w, b);
			Complex.mul(te, tc, td);
			Complex.mul(tf, tc, x);
			Complex.mul(tf, tf, 3d);
			Complex.add(tf, tf, te);
			Complex.add(tb, tb, tf);
			Complex.mul(te, w, w);
			Complex.mul(tf, w, 3d);
			Complex.sub(te, te, tf);
			Complex.add(te, te, c);
			Complex.mul(tf, td, x);
			Complex.mul(tf, tf, 3d);
			Complex.add(tf, tf, te);
			Complex.mul(te, ta, 3d);
			Complex.add(ta, tf, te);
			if (Complex.mod(ta) < 0.0000000000000000000001) {
				ta.r = 0.0000000000000000000001;
				ta.i = 0.0;
			}
			Complex.div(tc, tb, ta);
			Complex.mul(z, tc, tc);
			cp.zr = z.r;
			cp.zi = z.i;
			if (Complex.mod(z) > threshold) {
				cp.time = k;
				break;
			}
			Complex.sub(tc, z, a);
			if (Complex.mod(tc) < 0.0000001d) {
				cp.time = k;
				break;
			}
			x.r = cp.zr;
			x.i = cp.zi;
		}
		return cp.time;
	}

	/**
	 * @see net.sf.jame.mandelbrot.fractal.rendering.extension.RenderingFormulaExtensionRuntime#renderOrbit(net.sf.jame.mandelbrot.renderer.RenderedPoint)
	 */
	@Override
	public List<Complex> renderOrbit(final RenderedPoint cp) {
		final ArrayList<Complex> orbit = new ArrayList<Complex>();
		final Complex ta = new Complex(0, 0);
		final Complex tb = new Complex(0, 0);
		final Complex tc = new Complex(0, 0);
		final Complex td = new Complex(0, 0);
		final Complex te = new Complex(0, 0);
		final Complex tf = new Complex(0, 0);
		final Complex z = new Complex(0, 0);
		final Complex x = new Complex(cp.xr, cp.xi);
		final Complex w = new Complex(cp.wr, cp.wi);
		for (int k = 0; k < iterations; k++) {
			Complex.mul(ta, x, x);
			Complex.mul(tb, ta, x);
			Complex.sub(tc, w, a);
			Complex.sub(td, w, b);
			Complex.mul(te, tc, td);
			Complex.mul(tf, tc, x);
			Complex.mul(tf, tf, 3d);
			Complex.add(tf, tf, te);
			Complex.add(tb, tb, tf);
			Complex.mul(te, w, w);
			Complex.mul(tf, w, 3d);
			Complex.sub(te, te, tf);
			Complex.add(te, te, c);
			Complex.mul(tf, td, x);
			Complex.mul(tf, tf, 3d);
			Complex.add(tf, tf, te);
			Complex.mul(te, ta, 3d);
			Complex.add(ta, tf, te);
			if (Complex.mod(ta) < 0.0000000000000000000001) {
				ta.r = 0.0000000000000000000001;
				ta.i = 0.0;
			}
			Complex.div(tc, tb, ta);
			Complex.mul(z, tc, tc);
			orbit.add(new Complex(z.r, z.i));
			if (Complex.mod(z) > threshold) {
				break;
			}
			Complex.sub(tc, z, a);
			if (Complex.mod(tc) < 0.0000001d) {
				break;
			}
			x.r = z.r;
			x.i = z.i;
		}
		return orbit;
	}
}
