/*
 * $Id:YRuntime.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot.extensions.fractal.transforming;

import net.sf.jame.core.math.Complex;

/**
 * @author Andrea Medeghini
 */
public class YRuntime extends AbstractTransformingFormulaRuntime<YConfig> {
	/**
	 * @see net.sf.jame.mandelbrot.fractal.transforming.extension.TransformingFormulaExtensionRuntime#isHorizontalSymetryAllowed()
	 */
	@Override
	public boolean isHorizontalSymetryAllowed() {
		return true;
	}

	/**
	 * @see net.sf.jame.mandelbrot.fractal.transforming.extension.TransformingFormulaExtensionRuntime#isVerticalSymetryAllowed()
	 */
	@Override
	public boolean isVerticalSymetryAllowed() {
		return true;
	}

	/**
	 * @see net.sf.jame.mandelbrot.fractal.transforming.extension.TransformingFormulaExtensionRuntime#renderPoint(net.sf.jame.core.math.Complex)
	 */
	@Override
	public Complex renderPoint(final Complex w) {
		final double d = w.r * w.r + w.i * w.i;
		if (Math.abs(d) > 0.000000001) {
			final double m = 1 / ((w.r * w.r) + (w.i * w.i));
			w.r = +w.r * m + 0.25;
			w.i = -w.i * m;
		}
		else {
			w.r = 1000000000000000.0;
			w.i = 0;
		}
		return w;
	}
}
