/*
 * $Id:DefaultRendererConfigXMLImporterRuntime.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot.extensions.palette;

import java.util.List;

import net.sf.jame.core.xml.XMLImportException;
import net.sf.jame.core.xml.XMLImporter;
import net.sf.jame.mandelbrot.common.RenderedPaletteElement;
import net.sf.jame.mandelbrot.common.RenderedPaletteElementXMLImporter;
import net.sf.jame.twister.xmlimport.extension.ExtensionConfigXMLImporterExtensionRuntime;

import org.w3c.dom.Element;

/**
 * @author Andrea Medeghini
 */
public class DefaultRendererConfigXMLImporterRuntime extends ExtensionConfigXMLImporterExtensionRuntime {
	/**
	 * @see net.sf.jame.twister.xmlimport.extension.ExtensionConfigXMLImporterExtensionRuntime#createXMLImporter()
	 */
	@Override
	public XMLImporter<DefaultRendererConfig> createXMLImporter() {
		return new DefaultRendererConfigXMLImporter();
	}

	private class DefaultRendererConfigXMLImporter extends AbstractPaletteRendererConfigXMLImporter<DefaultRendererConfig> {
		/**
		 * @see net.sf.jame.mandelbrot.extensions.palette.AbstractPaletteRendererConfigXMLImporter#createExtensionConfig()
		 */
		@Override
		protected DefaultRendererConfig createExtensionConfig() {
			return new DefaultRendererConfig();
		}

		/**
		 * @see net.sf.jame.mandelbrot.extensions.palette.AbstractPaletteRendererConfigXMLImporter#getConfigElementClassId()
		 */
		@Override
		protected String getConfigElementClassId() {
			return "DefaultRendererConfig";
		}

		/**
		 * @see net.sf.jame.mandelbrot.extensions.palette.AbstractPaletteRendererConfigXMLImporter#getPropertiesSize()
		 */
		@Override
		protected int getPropertiesSize() {
			return 1;
		}

		/**
		 * @see net.sf.jame.mandelbrot.extensions.palette.AbstractPaletteRendererConfigXMLImporter#importProperties(net.sf.jame.mandelbrot.palette.extension.PaletteRendererExtensionConfig, java.util.List)
		 */
		@Override
		protected void importProperties(final DefaultRendererConfig config, final List<Element> propertyElements) throws XMLImportException {
			importRenderedPalette(config, propertyElements.get(0));
		}

		/**
		 * @param config
		 * @param element
		 * @throws XMLImportException
		 */
		protected void importRenderedPalette(final DefaultRendererConfig config, final Element element) throws XMLImportException {
			final List<Element> elements = this.getElements(element, RenderedPaletteElement.CLASS_ID);
			if (elements.size() == 1) {
				config.getRenderedPaletteElement().setValue(new RenderedPaletteElementXMLImporter().importFromElement(elements.get(0)).getValue());
			}
		}
	}
}
