/*
 * $Id:PaletteRendererConfigElementNode.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot.palette;

import java.io.Serializable;

import net.sf.jame.core.extension.ConfigurableExtensionReference;
import net.sf.jame.core.tree.Node;
import net.sf.jame.core.tree.NodeEditor;
import net.sf.jame.core.tree.NodeValue;
import net.sf.jame.mandelbrot.MandelbrotResources;
import net.sf.jame.mandelbrot.palette.extension.PaletteRendererExtensionConfig;
import net.sf.jame.twister.util.ConfigElementNode;
import net.sf.jame.twister.util.ConfigurableExtensionReferenceNode;

/**
 * @author Andrea Medeghini
 */
public class PaletteRendererConfigElementNode extends ConfigElementNode<PaletteRendererConfigElement> {
	public static final String NODE_ID = PaletteRendererConfigElement.CLASS_ID;
	public static final String NODE_CLASS = "node.class.PaletteRendererElement";
	private static final String NODE_LABEL = MandelbrotResources.getInstance().getString("node.label.PaletteRendererElement");
	private final PaletteRendererConfigElement rendererElement;

	/**
	 * @param rendererElement
	 */
	public PaletteRendererConfigElementNode(final PaletteRendererConfigElement rendererElement) {
		super(PaletteRendererConfigElementNode.NODE_ID);
		if (rendererElement == null) {
			throw new IllegalArgumentException("rendererElement is null");
		}
		this.rendererElement = rendererElement;
		if (rendererElement.getReference() != null) {
			setNodeValue(new PaletteRendererConfigElementNodeValue(rendererElement));
		}
		setNodeLabel(PaletteRendererConfigElementNode.NODE_LABEL);
		setNodeClass(PaletteRendererConfigElementNode.NODE_CLASS);
	}

	/**
	 * @see net.sf.jame.twister.util.ConfigElementNode#getConfigElement()
	 */
	@Override
	public PaletteRendererConfigElement getConfigElement() {
		return rendererElement;
	}

	protected void createChildNodes(final PaletteRendererConfigElementNodeValue value) {
		removeAllChildNodes();
		appendChildNode(new PaletteRendererReferenceNode(PaletteRendererConfigElementNode.NODE_ID + ".extension", value.getValue()));
	}

	private static class PaletteRendererReferenceNode extends ConfigurableExtensionReferenceNode<PaletteRendererExtensionConfig> {
		public static final String NODE_CLASS = "node.class.PaletteRendererReference";

		/**
		 * @param nodeId
		 * @param rendererElement
		 */
		public PaletteRendererReferenceNode(final String nodeId, final PaletteRendererConfigElement rendererElement) {
			super(nodeId, rendererElement.getExtensionElement());
			setNodeClass(PaletteRendererReferenceNode.NODE_CLASS);
		}

		/**
		 * @see net.sf.jame.twister.util.ConfigurableExtensionReferenceNode#createNodeValue(net.sf.jame.core.extension.ConfigurableExtensionReference)
		 */
		@Override
		protected NodeValue<?> createNodeValue(final ConfigurableExtensionReference<PaletteRendererExtensionConfig> value) {
			// return new PaletteRendererExtensionReferenceNodeValue(value != null ? value.clone() : null);
			return new PaletteRendererExtensionReferenceNodeValue(value);
		}
	}

	/**
	 * @see net.sf.jame.core.tree.DefaultNode#isEditable()
	 */
	@Override
	public boolean isEditable() {
		return true;
	}

	// private ExtensionReference getReference() {
	// if ((getNodeValue() != null) && (getNodeValue().getValue() != null)) {
	// return ((PaletteRendererConfigElementNodeValue) getNodeValue()).getValue().getReference();
	// }
	// return null;
	// }
	/**
	 * @see net.sf.jame.core.tree.Node#updateChildNodes()
	 */
	@Override
	protected void updateChildNodes() {
		createChildNodes((PaletteRendererConfigElementNodeValue) getNodeValue());
	}

	/**
	 * @see net.sf.jame.core.tree.DefaultNode#createNodeEditor()
	 */
	@Override
	protected NodeEditor createNodeEditor() {
		return new RendererNodeEditor(this);
	}

	private static class RendererNodeEditor extends NodeEditor {
		/**
		 * @param node
		 */
		public RendererNodeEditor(final Node node) {
			super(node);
		}

		/**
		 * @see net.sf.jame.core.tree.NodeEditor#createChildNode(net.sf.jame.core.tree.NodeValue)
		 */
		@Override
		protected Node createChildNode(final NodeValue<?> value) {
			return null;
		}

		/**
		 * @see net.sf.jame.core.tree.NodeEditor#createNodeValue(java.io.Serializable)
		 */
		@Override
		public NodeValue<?> createNodeValue(final Serializable value) {
			// return new PaletteRendererConfigElementNodeValue((PaletteRendererConfigElement) value != null ? ((PaletteRendererConfigElement) value).clone() : null);
			return new PaletteRendererConfigElementNodeValue((PaletteRendererConfigElement) value);
		}

		/**
		 * @see net.sf.jame.core.tree.NodeEditor#getNodeValueType()
		 */
		@Override
		public Class<?> getNodeValueType() {
			return PaletteRendererConfigElementNodeValue.class;
		}
	}
}
