/*
 * $Id:IncolouringFormulaElementTest.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot.test.fractal.incolouring;

import net.sf.jame.core.extension.ConfigurableExtensionReference;
import net.sf.jame.core.tree.Node;
import net.sf.jame.core.tree.NodeValue;
import net.sf.jame.mandelbrot.MandelbrotRegistry;
import net.sf.jame.mandelbrot.extensions.fractal.incolouring.ModulusConfig;
import net.sf.jame.mandelbrot.extensions.fractal.incolouring.PhaseConfig;
import net.sf.jame.mandelbrot.fractal.incolouring.IncolouringFormulaExtensionReferenceNodeValue;
import net.sf.jame.mandelbrot.fractal.incolouring.extension.IncolouringFormulaExtensionConfig;
import net.sf.jame.test.AbstractConfigurableExtensionConfigElementTest;
import net.sf.jame.twister.util.ConfigurableExtensionConfigElement;
import net.sf.jame.twister.util.ConfigurableExtensionConfigElementXMLExporter;
import net.sf.jame.twister.util.ConfigurableExtensionConfigElementXMLImporter;
import net.sf.jame.twister.util.ConfigurableExtensionReferenceNode;

import org.junit.Test;

/**
 * @author Andrea Medeghini
 */
public class IncolouringFormulaElementTest extends AbstractConfigurableExtensionConfigElementTest<IncolouringFormulaExtensionConfig> {
	@Override
	protected Node createElementNode() {
		return new ConfigurableExtensionReferenceNode<IncolouringFormulaExtensionConfig>("reference", getConfigElement()) {
			@Override
			protected NodeValue<?> createNodeValue(final ConfigurableExtensionReference<IncolouringFormulaExtensionConfig> value) {
				return new IncolouringFormulaExtensionReferenceNodeValue(value);
			}
		};
	}

	@Override
	protected ConfigurableExtensionConfigElement<IncolouringFormulaExtensionConfig> createConfigElement(final ConfigurableExtensionReference<IncolouringFormulaExtensionConfig> defaultValue) {
		final ConfigurableExtensionConfigElement<IncolouringFormulaExtensionConfig> configElement = new ConfigurableExtensionConfigElement<IncolouringFormulaExtensionConfig>();
		configElement.setReference(defaultValue);
		return configElement;
	}

	@Override
	protected ConfigurableExtensionConfigElementXMLExporter<IncolouringFormulaExtensionConfig> createXMLExporter() {
		return new ConfigurableExtensionConfigElementXMLExporter<IncolouringFormulaExtensionConfig>();
	}

	@Override
	protected ConfigurableExtensionConfigElementXMLImporter<IncolouringFormulaExtensionConfig> createXMLImporter() {
		return new ConfigurableExtensionConfigElementXMLImporter<IncolouringFormulaExtensionConfig>(MandelbrotRegistry.getInstance().getIncolouringFormulaRegistry());
	}

	@Override
	protected ConfigurableExtensionReference<IncolouringFormulaExtensionConfig> getFirstReference() {
		final ConfigurableExtensionReference<IncolouringFormulaExtensionConfig> reference = new ConfigurableExtensionReference<IncolouringFormulaExtensionConfig>("twister.mandelbrot.fractal.incolouring.formula.phase", "Phase", new PhaseConfig());
		return reference;
	}

	@Override
	protected ConfigurableExtensionReference<IncolouringFormulaExtensionConfig> getSecondReference() {
		final ConfigurableExtensionReference<IncolouringFormulaExtensionConfig> reference = new ConfigurableExtensionReference<IncolouringFormulaExtensionConfig>("twister.mandelbrot.fractal.incolouring.formula.modulus", "Modulus", new ModulusConfig());
		return reference;
	}

	@Override
	@Test
	public void testSetReference() {
		super.testSetReference();
	}

	@Override
	@Test
	public void testNode() {
		super.testNode();
	}

	@Override
	@Test
	public void testClone() {
		super.testClone();
	}

	@Override
	@Test
	public void testSerialization() {
		super.testSerialization();
	}

	@Override
	@Test
	public void testXML() {
		super.testXML();
	}
}
