/*
 * $Id:TransformingFormulaElementTest.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.mandelbrot.test.fractal.transforming;

import net.sf.jame.core.extension.ConfigurableExtensionReference;
import net.sf.jame.core.tree.Node;
import net.sf.jame.core.tree.NodeValue;
import net.sf.jame.mandelbrot.MandelbrotRegistry;
import net.sf.jame.mandelbrot.extensions.fractal.transforming.YConfig;
import net.sf.jame.mandelbrot.extensions.fractal.transforming.ZConfig;
import net.sf.jame.mandelbrot.fractal.transforming.TransformingFormulaExtensionReferenceNodeValue;
import net.sf.jame.mandelbrot.fractal.transforming.extension.TransformingFormulaExtensionConfig;
import net.sf.jame.test.AbstractConfigurableExtensionConfigElementTest;
import net.sf.jame.twister.util.ConfigurableExtensionConfigElement;
import net.sf.jame.twister.util.ConfigurableExtensionConfigElementXMLExporter;
import net.sf.jame.twister.util.ConfigurableExtensionConfigElementXMLImporter;
import net.sf.jame.twister.util.ConfigurableExtensionReferenceNode;

import org.junit.Test;

/**
 * @author Andrea Medeghini
 */
public class TransformingFormulaElementTest extends AbstractConfigurableExtensionConfigElementTest<TransformingFormulaExtensionConfig> {
	@Override
	protected Node createElementNode() {
		return new ConfigurableExtensionReferenceNode<TransformingFormulaExtensionConfig>("reference", getConfigElement()) {
			@Override
			protected NodeValue<?> createNodeValue(final ConfigurableExtensionReference<TransformingFormulaExtensionConfig> value) {
				return new TransformingFormulaExtensionReferenceNodeValue(value);
			}
		};
	}

	@Override
	protected ConfigurableExtensionConfigElement<TransformingFormulaExtensionConfig> createConfigElement(final ConfigurableExtensionReference<TransformingFormulaExtensionConfig> defaultValue) {
		final ConfigurableExtensionConfigElement<TransformingFormulaExtensionConfig> configElement = new ConfigurableExtensionConfigElement<TransformingFormulaExtensionConfig>();
		configElement.setReference(defaultValue);
		return configElement;
	}

	@Override
	protected ConfigurableExtensionConfigElementXMLExporter<TransformingFormulaExtensionConfig> createXMLExporter() {
		return new ConfigurableExtensionConfigElementXMLExporter<TransformingFormulaExtensionConfig>();
	}

	@Override
	protected ConfigurableExtensionConfigElementXMLImporter<TransformingFormulaExtensionConfig> createXMLImporter() {
		return new ConfigurableExtensionConfigElementXMLImporter<TransformingFormulaExtensionConfig>(MandelbrotRegistry.getInstance().getTransformingFormulaRegistry());
	}

	@Override
	protected ConfigurableExtensionReference<TransformingFormulaExtensionConfig> getFirstReference() {
		final ConfigurableExtensionReference<TransformingFormulaExtensionConfig> reference = new ConfigurableExtensionReference<TransformingFormulaExtensionConfig>("twister.mandelbrot.fractal.transforming.formula.z", "Z", new ZConfig());
		return reference;
	}

	@Override
	protected ConfigurableExtensionReference<TransformingFormulaExtensionConfig> getSecondReference() {
		final ConfigurableExtensionReference<TransformingFormulaExtensionConfig> reference = new ConfigurableExtensionReference<TransformingFormulaExtensionConfig>("twister.mandelbrot.fractal.transforming.formula.y", "Y", new YConfig());
		return reference;
	}

	@Override
	@Test
	public void testSetReference() {
		super.testSetReference();
	}

	@Override
	@Test
	public void testNode() {
		super.testNode();
	}

	@Override
	@Test
	public void testClone() {
		super.testClone();
	}

	@Override
	@Test
	public void testSerialization() {
		super.testSerialization();
	}

	@Override
	@Test
	public void testXML() {
		super.testXML();
	}
}
