/*
 * $Id:FireData.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.gfx;

public final class FireData extends Effect {
	private final ColorMap colormap = new FireMap();

	public FireData() {
	}

	@Override
	public String getName() {
		return "Fire";
	}

	public ColorMap getColorMap() {
		return colormap;
	}

	private final class FireMap extends ColorMap {
		private final byte[][] data;

		public FireMap() {
			data = new byte[4][256];
			int i = 1;
			byte c = (byte) 0;
			data[0][0] = (byte) 0;
			data[1][0] = (byte) 0;
			data[2][0] = (byte) 0;
			data[3][0] = (byte) 0;
			// black to red
			while (i < 64) {
				data[0][i] = c;
				data[1][i] = (byte) 0;
				data[2][i] = (byte) 0;
				data[3][i] = (byte) (i * 2);
				c += 4;
				i++;
			}
			c = 0;
			// red to yellow
			while (i < 128) {
				data[0][i] = (byte) 255;
				data[1][i] = c;
				data[2][i] = (byte) 0;
				data[3][i] = (byte) 196;
				c += 4;
				i++;
			}
			c = 0;
			// yellow to white
			while (i < 256) {
				data[0][i] = (byte) 255;
				data[1][i] = (byte) 255;
				data[2][i] = c;
				data[3][i] = (byte) 196;
				c += 4;
				i++;
			}
		}

		@Override
		public byte[] getRed() {
			return data[0];
		}

		@Override
		public byte[] getGreen() {
			return data[1];
		}

		@Override
		public byte[] getBlue() {
			return data[2];
		}

		@Override
		public byte[] getAlpha() {
			return data[3];
		}
	}
}
