/*
 * $Id:EngineImage.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.media;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;

import javax.imageio.ImageIO;

class EngineImage {
	BufferedImage image;
	BufferedImage copy;

	public EngineImage(final URL url) {
		try {
			final BufferedImage sorgente = ImageIO.read(url);
			copy = new BufferedImage(sorgente.getWidth(), sorgente.getHeight(), BufferedImage.TYPE_INT_ARGB);
			copy.createGraphics().drawImage(sorgente, 0, 0, null);
			image = new BufferedImage(sorgente.getWidth(), sorgente.getHeight(), BufferedImage.TYPE_INT_ARGB);
			image.createGraphics().drawImage(sorgente, 0, 0, null);
			sorgente.flush();
		}
		catch (final IOException e) {
			e.printStackTrace();
		}
	}

	public EngineImage(final BufferedImage sorgente) {
		image = new BufferedImage(sorgente.getWidth(), sorgente.getHeight(), BufferedImage.TYPE_INT_ARGB);
		image.createGraphics().drawImage(sorgente, 0, 0, null);
		copy = sorgente;
	}

	@Override
	public Object clone() throws CloneNotSupportedException {
		return new EngineImage(copy);
	}

	public void applyEffect(final Effect effect) {
		effect.filterImage(copy, image);
	}

	public BufferedImage getImage() {
		return image;
	}

	public int getWidth() {
		return image.getWidth();
	}

	public int getHeight() {
		return image.getHeight();
	}
}
