/*
 * $Id:ServiceMessage.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.networking;

import java.io.Serializable;

/**
 * @author Andrea Medeghini
 */
public abstract class ServiceMessage implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	public static final int MESSAGE_TYPE_FAILURE = 10;
	public static final int MESSAGE_TYPE_EVENT = 20;
	public static final int MESSAGE_TYPE_REQUEST = 30;
	public static final int MESSAGE_TYPE_RESPONSE = 40;
	public static final int MESSAGE_TYPE_KEEPALIVE = 50;
	private final String messageId;
	private final int messageType;

	/**
	 * @param messageId
	 * @param messageType
	 */
	protected ServiceMessage(final String messageId, final int messageType) {
		this.messageId = messageId;
		this.messageType = messageType;
	}

	/**
	 * @return the messageType
	 */
	public int getMessageType() {
		return messageType;
	}

	/**
	 * @return the messageId
	 */
	public String getMessageId() {
		return messageId;
	}

	/**
	 * @param messageTpe
	 * @return
	 */
	public static final String decodeMessageType(final int messageType) {
		switch (messageType) {
			case MESSAGE_TYPE_EVENT:
				return "EVENT";
			case MESSAGE_TYPE_FAILURE:
				return "FAILURE";
			case MESSAGE_TYPE_KEEPALIVE:
				return "KEEPALIVE";
			case MESSAGE_TYPE_REQUEST:
				return "REQUEST";
			case MESSAGE_TYPE_RESPONSE:
				return "RESPONSE";
			default:
				return "unknown";
		}
	}
}
