/*
 * $Id:DummyRemoteJob.java 491 2008-01-28 21:59:31Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.networking.test;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

import net.sf.jame.service.job.RenderJobDataRow;
import net.sf.jame.service.spool.DistributedSpoolJobInterface;
import net.sf.jame.service.spool.JobListener;
import net.sf.jame.twister.TwisterClip;

/**
 * @author Andrea Medeghini
 */
public class DummyRemoteJob implements DistributedSpoolJobInterface {
	private final JobListener listener;
	private String jobId;
	private String remoteJobId;
	private int frameNumber;
	private byte[] dataIn;
	private final byte[] dataOut;
	private long lastUpdate;
	private boolean started;
	private boolean aborted;
	private boolean terminated;

	/**
	 * @param dataOut
	 * @param dataIn
	 * @param listener
	 */
	public DummyRemoteJob(final byte[] dataIn, final byte[] dataOut, final JobListener listener) {
		lastUpdate = System.currentTimeMillis();
		this.listener = listener;
		this.dataIn = dataIn;
		this.dataOut = dataOut;
	}

	/**
	 * @see net.sf.jame.service.spool.JobInterface#setJobId(java.lang.String)
	 */
	public void setJobId(final String id) {
		jobId = id;
	}

	/**
	 * @see net.sf.jame.service.spool.JobInterface#getJobId()
	 */
	public String getJobId() {
		return jobId;
	}

	/**
	 * @see net.sf.jame.service.spool.JobInterface#getFrameNumber()
	 */
	public int getFrameNumber() {
		return frameNumber;
	}

	/**
	 * @see net.sf.jame.service.spool.JobInterface#setFrameNumber(int)
	 */
	public void setFrameNumber(final int frameNumber) {
		this.frameNumber = frameNumber;
		lastUpdate = System.currentTimeMillis();
		listener.stateChanged(this);
	}

	/**
	 * @see net.sf.jame.service.spool.JobInterface#writeData(byte[])
	 */
	public void writeData(final byte[] data) throws IOException {
		dataIn = new byte[data.length];
		System.arraycopy(data, 0, dataIn, 0, data.length);
	}

	/**
	 * @see net.sf.jame.service.spool.JobInterface#readData()
	 */
	public byte[] readData() throws IOException {
		final byte[] data = new byte[dataOut.length];
		System.arraycopy(dataOut, 0, data, 0, data.length);
		return data;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		final StringBuilder builder = new StringBuilder();
		builder.append("id = ");
		builder.append(jobId);
		builder.append(", frameNumber = ");
		builder.append(frameNumber);
		return builder.toString();
	}

	/**
	 * @see net.sf.jame.service.spool.JobInterface#getLastUpdate()
	 */
	public long getLastUpdate() {
		return lastUpdate;
	}

	/**
	 * @see net.sf.jame.service.spool.JobInterface#reset()
	 */
	public void reset() {
		started = false;
		aborted = false;
		terminated = false;
	}

	/**
	 * @see net.sf.jame.service.spool.JobInterface#start()
	 */
	public void start() {
		started = true;
		aborted = false;
		terminated = false;
		listener.started(this);
	}

	/**
	 * @see net.sf.jame.service.spool.JobInterface#stop()
	 */
	public void stop() {
		started = false;
		terminated = true;
		listener.stopped(this);
	}

	/**
	 * @see net.sf.jame.service.spool.JobInterface#abort()
	 */
	public void abort() {
		started = false;
		aborted = true;
		terminated = true;
		listener.stopped(this);
	}

	/**
	 * @see net.sf.jame.service.spool.JobInterface#dispose()
	 */
	public void dispose() {
	}

	/**
	 * @see net.sf.jame.service.spool.JobInterface#isStarted()
	 */
	public boolean isStarted() {
		return started;
	}

	/**
	 * @see net.sf.jame.service.spool.JobInterface#isAborted()
	 */
	public boolean isAborted() {
		return aborted;
	}

	/**
	 * @see net.sf.jame.service.spool.JobInterface#isTerminated()
	 */
	public boolean isTerminated() {
		return terminated;
	}

	/**
	 * @see net.sf.jame.service.spool.DistributedSpoolJobInterface#getRemoteJobId()
	 */
	public String getRemoteJobId() {
		return remoteJobId;
	}

	/**
	 * @see net.sf.jame.service.spool.DistributedSpoolJobInterface#setRemoteJobId(java.lang.String)
	 */
	public void setRemoteJobId(final String remoteJobId) {
		this.remoteJobId = remoteJobId;
	}

	/**
	 * @see net.sf.jame.service.spool.SpoolJobInterface#getJobDataRow()
	 */
	public RenderJobDataRow getJobDataRow() {
		return null;
	}

	/**
	 * @see net.sf.jame.service.spool.SpoolJobInterface#setJobDataRow(net.sf.jame.service.job.RenderJobDataRow)
	 */
	public void setJobDataRow(final RenderJobDataRow job) {
	}

	/**
	 * @see net.sf.jame.service.spool.DistributedSpoolJobInterface#getStream()
	 */
	public OutputStream getStream() throws IOException {
		return null;
	}

	/**
	 * @see net.sf.jame.service.spool.SpoolJobInterface#getClip()
	 */
	public TwisterClip getClip() throws IOException {
		return null;
	}

	/**
	 * @see net.sf.jame.service.spool.DistributedSpoolJobInterface#getStream(boolean)
	 */
	public OutputStream getStream(final boolean append) throws IOException {
		return null;
	}

	/**
	 * @see net.sf.jame.service.spool.DistributedSpoolJobInterface#getRAF()
	 */
	public RandomAccessFile getRAF() throws IOException {
		return null;
	}

	/**
	 * @see net.sf.jame.service.spool.DistributedSpoolJobInterface#getTotalFrames()
	 */
	public int getTotalFrames() {
		return 1;
	}

	/**
	 * @see net.sf.jame.service.spool.DistributedSpoolJobInterface#setTerminated(boolean)
	 */
	public void setTerminated(boolean terminated) {
		terminated = true;
	}
}
