/*
 * $Id:RenderJobDataRow.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.service.job;

/**
 * @author Andrea Medeghini
 */
public final class RenderJobDataRow {
	private int jobId;
	private int profileId;
	private int clipId;
	private int status;
	private int type;
	private final RenderJob job;

	/**
	 * @param job
	 */
	public RenderJobDataRow(final RenderJob job) {
		this.job = job;
	}

	/**
	 * @return the id
	 */
	public int getJobId() {
		return jobId;
	}

	/**
	 * @param jobId the id to set
	 */
	public void setJobId(final int jobId) {
		this.jobId = jobId;
	}

	/**
	 * @return the profileId
	 */
	public int getProfileId() {
		return profileId;
	}

	/**
	 * @param profileId the profileId to set
	 */
	public void setProfileId(final int profileId) {
		this.profileId = profileId;
	}

	/**
	 * @return the clipId
	 */
	public int getClipId() {
		return clipId;
	}

	/**
	 * @param clipId the clipId to set
	 */
	public void setClipId(final int clipId) {
		this.clipId = clipId;
	}

	/**
	 * @return the status
	 */
	public int getStatus() {
		return status;
	}

	/**
	 * @param status the status to set
	 */
	public void setStatus(final int status) {
		this.status = status;
	}

	/**
	 * @return the type
	 */
	public int getType() {
		return type;
	}

	/**
	 * @param type the type to set
	 */
	public void setType(final int type) {
		this.type = type;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		final StringBuilder builder = new StringBuilder();
		builder.append("RenderJob[jobId = ");
		builder.append(jobId);
		builder.append(", profileId = ");
		builder.append(getProfileId());
		builder.append(", clipId = ");
		builder.append(getClipId());
		builder.append(", name = ");
		builder.append(getJob().getProfileName());
		builder.append(", frameNumber = ");
		builder.append(getJob().getFrameNumber());
		builder.append(", tileWidth = ");
		builder.append(getJob().getTileWidth());
		builder.append(", tileHeight = ");
		builder.append(getJob().getTileHeight());
		builder.append(", tileOffsetX = ");
		builder.append(getJob().getTileOffsetX());
		builder.append(", tileOffsetY = ");
		builder.append(getJob().getTileOffsetY());
		builder.append(", borderWidth = ");
		builder.append(getJob().getBorderWidth());
		builder.append(", borderHeight = ");
		builder.append(getJob().getBorderHeight());
		builder.append(", status = ");
		builder.append(getStatus());
		builder.append(", type = ");
		builder.append(getType());
		builder.append("]");
		return builder.toString();
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(final Object obj) {
		if (obj == null) {
			return false;
		}
		return getJobId() == ((RenderJobDataRow) obj).getJobId();
	}

	/**
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return getJobId();
	}

	/**
	 * @return the job
	 */
	public RenderJob getJob() {
		return job;
	}

	/**
	 * @return
	 * @see net.sf.jame.service.job.RenderJob#getBorderHeight()
	 */
	public int getBorderHeight() {
		return job.getBorderHeight();
	}

	/**
	 * @return
	 * @see net.sf.jame.service.job.RenderJob#getBorderWidth()
	 */
	public int getBorderWidth() {
		return job.getBorderWidth();
	}

	/**
	 * @return
	 * @see net.sf.jame.service.job.RenderJob#getClipName()
	 */
	public String getClipName() {
		return job.getClipName();
	}

	/**
	 * @return
	 * @see net.sf.jame.service.job.RenderJob#getFrameNumber()
	 */
	public int getFrameNumber() {
		return job.getFrameNumber();
	}

	/**
	 * @return
	 * @see net.sf.jame.service.job.RenderJob#getFrameRate()
	 */
	public int getFrameRate() {
		return job.getFrameRate();
	}

	/**
	 * @return
	 * @see net.sf.jame.service.job.RenderJob#getImageHeight()
	 */
	public int getImageHeight() {
		return job.getImageHeight();
	}

	/**
	 * @return
	 * @see net.sf.jame.service.job.RenderJob#getImageWidth()
	 */
	public int getImageWidth() {
		return job.getImageWidth();
	}

	/**
	 * @return
	 * @see net.sf.jame.service.job.RenderJob#getProfileName()
	 */
	public String getProfileName() {
		return job.getProfileName();
	}

	/**
	 * @return
	 * @see net.sf.jame.service.job.RenderJob#getQuality()
	 */
	public int getQuality() {
		return job.getQuality();
	}

	/**
	 * @return
	 * @see net.sf.jame.service.job.RenderJob#getStartTime()
	 */
	public int getStartTime() {
		return job.getStartTime();
	}

	/**
	 * @return
	 * @see net.sf.jame.service.job.RenderJob#getStopTime()
	 */
	public int getStopTime() {
		return job.getStopTime();
	}

	/**
	 * @return
	 * @see net.sf.jame.service.job.RenderJob#getTileHeight()
	 */
	public int getTileHeight() {
		return job.getTileHeight();
	}

	/**
	 * @return
	 * @see net.sf.jame.service.job.RenderJob#getTileOffsetX()
	 */
	public int getTileOffsetX() {
		return job.getTileOffsetX();
	}

	/**
	 * @return
	 * @see net.sf.jame.service.job.RenderJob#getTileOffsetY()
	 */
	public int getTileOffsetY() {
		return job.getTileOffsetY();
	}

	/**
	 * @return
	 * @see net.sf.jame.service.job.RenderJob#getTileWidth()
	 */
	public int getTileWidth() {
		return job.getTileWidth();
	}

	/**
	 * @param tileBorderHeight
	 * @see net.sf.jame.service.job.RenderJob#setBorderHeight(int)
	 */
	public void setBorderHeight(final int tileBorderHeight) {
		job.setBorderHeight(tileBorderHeight);
	}

	/**
	 * @param tileBorderWidth
	 * @see net.sf.jame.service.job.RenderJob#setBorderWidth(int)
	 */
	public void setBorderWidth(final int tileBorderWidth) {
		job.setBorderWidth(tileBorderWidth);
	}

	/**
	 * @param clipName
	 * @see net.sf.jame.service.job.RenderJob#setClipName(java.lang.String)
	 */
	public void setClipName(final String clipName) {
		job.setClipName(clipName);
	}

	/**
	 * @param frame
	 * @see net.sf.jame.service.job.RenderJob#setFrameNumber(int)
	 */
	public void setFrameNumber(final int frame) {
		job.setFrameNumber(frame);
	}

	/**
	 * @param frameRate
	 * @see net.sf.jame.service.job.RenderJob#setFrameRate(int)
	 */
	public void setFrameRate(final int frameRate) {
		job.setFrameRate(frameRate);
	}

	/**
	 * @param imageHeight
	 * @see net.sf.jame.service.job.RenderJob#setImageHeight(int)
	 */
	public void setImageHeight(final int imageHeight) {
		job.setImageHeight(imageHeight);
	}

	/**
	 * @param imageWidth
	 * @see net.sf.jame.service.job.RenderJob#setImageWidth(int)
	 */
	public void setImageWidth(final int imageWidth) {
		job.setImageWidth(imageWidth);
	}

	/**
	 * @param profileName
	 * @see net.sf.jame.service.job.RenderJob#setProfileName(java.lang.String)
	 */
	public void setProfileName(final String profileName) {
		job.setProfileName(profileName);
	}

	/**
	 * @param quality
	 * @see net.sf.jame.service.job.RenderJob#setQuality(int)
	 */
	public void setQuality(final int quality) {
		job.setQuality(quality);
	}

	/**
	 * @param startTime
	 * @see net.sf.jame.service.job.RenderJob#setStartTime(int)
	 */
	public void setStartTime(final int startTime) {
		job.setStartTime(startTime);
	}

	/**
	 * @param stopTime
	 * @see net.sf.jame.service.job.RenderJob#setStopTime(int)
	 */
	public void setStopTime(final int stopTime) {
		job.setStopTime(stopTime);
	}

	/**
	 * @param tileHeight
	 * @see net.sf.jame.service.job.RenderJob#setTileHeight(int)
	 */
	public void setTileHeight(final int tileHeight) {
		job.setTileHeight(tileHeight);
	}

	/**
	 * @param tileOffsetX
	 * @see net.sf.jame.service.job.RenderJob#setTileOffsetX(int)
	 */
	public void setTileOffsetX(final int tileOffsetX) {
		job.setTileOffsetX(tileOffsetX);
	}

	/**
	 * @param tileOffsetY
	 * @see net.sf.jame.service.job.RenderJob#setTileOffsetY(int)
	 */
	public void setTileOffsetY(final int tileOffsetY) {
		job.setTileOffsetY(tileOffsetY);
	}

	/**
	 * @param tileWidth
	 * @see net.sf.jame.service.job.RenderJob#setTileWidth(int)
	 */
	public void setTileWidth(final int tileWidth) {
		job.setTileWidth(tileWidth);
	}

	/**
	 * @return
	 */
	public boolean isPostProcess() {
		return type == 2;
	}

	/**
	 * @return
	 */
	public boolean isCopyProcess() {
		return type == 1;
	}

	/**
	 * @return
	 */
	public boolean isProcess() {
		return type == 0;
	}
}
