/*
 * $Id:TestMovieClipDataTable.java 456 2008-01-05 21:56:57Z andreamedeghini $
 *
 * JAME is a Java real-time multi-thread fractal graphics platform
 * Copyright (C) 2001, 2008 Andrea Medeghini
 * andreamedeghini@users.sf.net
 * http://jame.sourceforge.net
 * http://sourceforge.net/projects/jame
 * http://jame.dev.java.net
 * http://jugbrescia.dev.java.net
 *
 * This file is part of JAME.
 *
 * JAME is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JAME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JAME.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package net.sf.jame.service.test;

import java.io.File;
import java.util.List;

import net.sf.jame.service.ConnectionFactory;
import net.sf.jame.service.DefaultConnectionFactory;
import net.sf.jame.service.Session;
import net.sf.jame.service.clip.MovieClip;
import net.sf.jame.service.clip.MovieClipDataRow;
import net.sf.jame.service.clip.MovieClipDataTable;

import org.junit.Assert;
import org.junit.Test;

public class TestMovieClipDataTable {
	@Test
	public void testCreate() {
		try {
			final ConnectionFactory factory = new DefaultConnectionFactory(new File("workdir"));
			final Session session = new Session(factory);
			session.openTransaction();
			final MovieClipDataTable dataTable = new MovieClipDataTable();
			dataTable.deleteAll(session);
			dataTable.create(session, createClip());
			dataTable.create(session, createClip());
			dataTable.create(session, createClip());
			dataTable.create(session, createClip());
			final List<MovieClipDataRow> clips = dataTable.loadAll(session);
			printClips(clips);
			Assert.assertEquals(4, clips.size());
			session.closeTransaction();
			session.close();
		}
		catch (final Exception e) {
			e.printStackTrace();
			Assert.fail();
		}
	}

	@Test
	public void testSave() {
		try {
			final ConnectionFactory factory = new DefaultConnectionFactory(new File("workdir"));
			final Session session = new Session(factory);
			session.openTransaction();
			final MovieClipDataTable dataTable = new MovieClipDataTable();
			dataTable.deleteAll(session);
			MovieClipDataRow clip = createClip();
			dataTable.create(session, clip);
			clip.setClipName("Name");
			clip.setDescription("Description");
			dataTable.save(session, clip);
			clip = dataTable.load(session, clip.getClipId());
			System.out.println(clip);
			Assert.assertEquals("Name", clip.getClipName());
			Assert.assertEquals("Description", clip.getDescription());
			session.closeTransaction();
			session.close();
		}
		catch (final Exception e) {
			e.printStackTrace();
			Assert.fail();
		}
	}

	@Test
	public void testDelete() {
		try {
			final ConnectionFactory factory = new DefaultConnectionFactory(new File("workdir"));
			final Session session = new Session(factory);
			session.openTransaction();
			final MovieClipDataTable dataTable = new MovieClipDataTable();
			dataTable.deleteAll(session);
			final MovieClipDataRow clip = createClip();
			dataTable.create(session, clip);
			dataTable.delete(session, clip);
			final List<MovieClipDataRow> clips = dataTable.loadAll(session);
			Assert.assertEquals(0, clips.size());
			session.closeTransaction();
			session.close();
		}
		catch (final Exception e) {
			e.printStackTrace();
			Assert.fail();
		}
	}

	@Test
	public void testLoad() {
		try {
			final ConnectionFactory factory = new DefaultConnectionFactory(new File("workdir"));
			final Session session = new Session(factory);
			session.openTransaction();
			final MovieClipDataTable dataTable = new MovieClipDataTable();
			dataTable.deleteAll(session);
			final MovieClipDataRow clip = createClip();
			for (int i = 0; i < 4; i++) {
				dataTable.create(session, clip);
				clip.setClipName("Name" + i);
				clip.setDescription("Description" + i);
				dataTable.save(session, clip);
			}
			clip.setClipName("%Na%");
			clip.setDescription("%");
			List<MovieClipDataRow> clips = dataTable.load(session, clip);
			printClips(clips);
			Assert.assertEquals(4, clips.size());
			clip.setClipName("%1");
			clip.setDescription("%1");
			clips = dataTable.load(session, clip);
			printClips(clips);
			Assert.assertEquals(1, clips.size());
			session.closeTransaction();
			session.close();
		}
		catch (final Exception e) {
			e.printStackTrace();
			Assert.fail();
		}
	}

	private MovieClipDataRow createClip() {
		final MovieClipDataRow clip = new MovieClipDataRow(new MovieClip());
		clip.setClipName("Test Name");
		clip.setDescription("Test Description");
		return clip;
	}

	private void printClips(final List<MovieClipDataRow> clips) {
		for (final MovieClipDataRow clip : clips) {
			System.out.println(clip);
		}
	}
}
